/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.route;

import org.jetlinks.core.route.MqttRoute;

class DefaultMqttRoute
implements MqttRoute {
    private final String topic;
    private final boolean upstream;
    private final boolean downstream;
    private final int qos;
    private final String group;
    private final String description;
    private final String example;

    DefaultMqttRoute(String topic, boolean upstream, boolean downstream, int qos, String group, String description, String example) {
        this.topic = topic;
        this.upstream = upstream;
        this.downstream = downstream;
        this.qos = qos;
        this.group = group;
        this.description = description;
        this.example = example;
    }

    static DefaultMqttRouteBuilder builder() {
        return new DefaultMqttRouteBuilder();
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isUpstream() {
        return this.upstream;
    }

    @Override
    public boolean isDownstream() {
        return this.downstream;
    }

    @Override
    public int getQos() {
        return this.qos;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExample() {
        return this.example;
    }

    static class DefaultMqttRouteBuilder
    implements MqttRoute.Builder {
        private String topic;
        private boolean upstream;
        private boolean downstream;
        private int qos;
        private String group;
        private String description;
        private String example;

        DefaultMqttRouteBuilder() {
        }

        @Override
        public DefaultMqttRouteBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder upstream(boolean upstream) {
            this.upstream = upstream;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder downstream(boolean downstream) {
            this.downstream = downstream;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder qos(int qos) {
            this.qos = qos;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DefaultMqttRouteBuilder example(String example) {
            this.example = example;
            return this;
        }

        @Override
        public DefaultMqttRoute build() {
            return new DefaultMqttRoute(this.topic, this.upstream, this.downstream, this.qos, this.group, this.description, this.example);
        }

        public String toString() {
            return "DefaultMqttRoute.DefaultMqttRouteBuilder(topic=" + this.topic + ", upstream=" + this.upstream + ", downstream=" + this.downstream + ", qos=" + this.qos + ", group=" + this.group + ", description=" + this.description + ", example=" + this.example + ")";
        }
    }
}

