/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;

public class DirectDeviceMessage
extends CommonDeviceMessage<DirectDeviceMessage> {
    private byte[] payload;

    @Override
    public MessageType getMessageType() {
        return MessageType.DIRECT;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.setPayload(jsonObject.getBytes("payload"));
        this.setDeviceId(jsonObject.getString("deviceId"));
        this.setMessageId(jsonObject.getString("messageId"));
        Long ts = jsonObject.getLong("timestamp");
        if (null != ts) {
            this.setTimestamp(ts);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.payload.length);
            out.write(this.payload);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int len = in.readInt();
        if (len > 0) {
            this.payload = new byte[len];
            in.readFully(this.payload);
        }
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }
}

