/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpClientMetricsHandler.class);
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpClientMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpClientMetricsHandler(AbstractHttpClientMetricsHandler copy) {
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.method = copy.method;
        this.path = copy.path;
        this.status = copy.status;
        this.uriTagValue = copy.uriTagValue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block4: {
            try {
                if (msg instanceof HttpRequest) {
                    this.extractDetailsFromHttpRequest(ctx, (HttpRequest)msg);
                }
                this.dataSent += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    SocketAddress address = ctx.channel().remoteAddress();
                    promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                        block2: {
                            try {
                                this.recordWrite(address);
                            }
                            catch (RuntimeException e) {
                                if (!log.isWarnEnabled()) break block2;
                                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                            }
                        }
                    }));
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block4: {
            try {
                if (msg instanceof HttpResponse) {
                    this.status = ((HttpResponse)msg).status().codeAsText().toString();
                    this.dataReceivedTime = System.nanoTime();
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.recordRead(ctx.channel().remoteAddress());
                    this.reset();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx);
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private void extractDetailsFromHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        this.method = request.method().name();
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            HttpClientOperations ops = (HttpClientOperations)channelOps;
            this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
            this.contextView = ops.currentContextView();
        }
        this.dataSentTime = System.nanoTime();
    }

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        this.recorder().incrementErrorsCount(ctx.channel().remoteAddress(), this.path != null ? this.path : this.resolveUri(ctx));
    }

    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
    }

    protected void recordWrite(SocketAddress address) {
        this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataSent(address, this.path, this.dataSent);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path2 = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path2 : this.uriTagValue.apply(path2);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

