/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network.http;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.Global;
import org.jetlinks.simulator.core.network.AbstractConnection;
import org.jetlinks.simulator.core.network.Address;
import org.jetlinks.simulator.core.network.AddressManager;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.NetworkUtils;
import org.jetlinks.simulator.core.network.http.HTTPClientOptions;
import org.jetlinks.simulator.core.network.http.HttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class HTTPClient
extends AbstractConnection {
    private final String id;
    private final String basePath;
    private final HttpClient client;
    private final HttpHeaders headers;
    private final Address address;

    public static String statusCountAttr(HttpStatus status) {
        return Connection.statusCountAttr(status.name());
    }

    private HTTPClient(String id, String basePath, HttpHeaders headers2, Address address, HttpClient client) {
        this.id = id;
        this.basePath = basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath;
        this.client = client;
        this.headers = headers2 == null ? HttpHeaders.EMPTY : headers2;
        this.address = address;
        this.changeState(Connection.State.connected);
    }

    public static Mono<HTTPClient> create(HTTPClientOptions options) {
        Address addr = AddressManager.global().takeAddress(options.getLocalAddress());
        try {
            options.setLocalAddress(addr.getAddress().getHostAddress());
            options.setSsl(options.getBasePath().startsWith("https"));
            return Mono.just(new HTTPClient(options.getId(), options.getBasePath(), options.getHeaders(), addr, Global.vertx().createHttpClient(options)));
        }
        catch (Throwable err) {
            addr.release();
            throw err;
        }
    }

    public Mono<HttpResponse> patchJsonAsync(String path2, Object body2) {
        return this.patchAsync(path2, body2, "application/json");
    }

    public Mono<HttpResponse> patchAsync(String path2, Object body2, String mediaType) {
        return this.request(HttpMethod.PATCH, path2, body2, mediaType);
    }

    public Mono<HttpResponse> putJsonAsync(String path2, Object body2) {
        return this.putAsync(path2, body2, "application/json");
    }

    public Mono<HttpResponse> putAsync(String path2, Object body2, String mediaType) {
        return this.request(HttpMethod.PUT, path2, body2, mediaType);
    }

    public Mono<HttpResponse> postJsonAsync(String path2, Object body2) {
        return this.postAsync(path2, body2, "application/json");
    }

    public Mono<HttpResponse> postAsync(String path2, Object body2, String mediaType) {
        return this.request(HttpMethod.POST, path2, body2, mediaType);
    }

    public void request(Map<String, Object> map) {
        this.requestAsync(map).subscribe();
    }

    public Mono<HttpResponse> requestAsync(Map<String, Object> map) {
        HttpMethod method2 = HttpMethod.valueOf(String.valueOf(map.getOrDefault("method", "GET")).toUpperCase());
        String path2 = String.valueOf(map.getOrDefault("path", "/"));
        Object body2 = map.get("body");
        String contentType2 = (String)map.get("contentType");
        Map<String, Object> headers2 = map.getOrDefault("headers", Collections.emptyMap());
        HttpHeaders httpHeaders = new HttpHeaders();
        if (headers2 != null) {
            headers2.forEach((k, v) -> httpHeaders.add((String)k, String.valueOf(v)));
        }
        return this.request(method2, path2, body2, contentType2, httpHeaders);
    }

    public Mono<HttpResponse> request(HttpMethod method2, String path2, Object body2, String mediaType, HttpHeaders headers2) {
        ByteBuf payload = NetworkUtils.castToByteBuf(body2);
        Buffer buffer = Buffer.buffer(payload);
        int len = buffer.length();
        return Mono.defer(() -> this.request(this.createRequest(method2, path2), headers2, req -> {
            if (null != mediaType) {
                req.putHeader("Content-Type", mediaType);
            }
            return req.send(buffer);
        })).doAfterTerminate(() -> {
            this.sent(len);
            ReferenceCountUtil.safeRelease(payload);
        });
    }

    public Mono<HttpResponse> request(HttpMethod method2, String path2, Object body2, String mediaType) {
        return this.request(method2, path2, body2, mediaType, null);
    }

    public Mono<HttpResponse> deleteAsync(String path2) {
        return Mono.defer(() -> this.request(this.createRequest(HttpMethod.DELETE, path2), null, HttpClientRequest::connect));
    }

    public Mono<HttpResponse> getAsync(String path2) {
        return Mono.defer(() -> this.request(this.createRequest(HttpMethod.GET, path2), null, HttpClientRequest::connect));
    }

    private Future<HttpClientRequest> createRequest(HttpMethod method2, String path2) {
        int port;
        URI uri = URI.create(this.getPath(path2));
        String pathAll = uri.getPath();
        if (StringUtils.hasText(uri.getQuery())) {
            pathAll = pathAll + "?" + uri.getQuery();
        }
        if ((port = uri.getPort()) <= 0) {
            port = "https".equals(uri.getScheme()) ? 443 : 80;
        }
        return this.client.request(method2, port, uri.getHost(), pathAll);
    }

    private Mono<HttpResponse> request(Future<HttpClientRequest> feature, HttpHeaders headers2, Function<HttpClientRequest, Future<HttpClientResponse>> sender) {
        return Mono.fromCompletionStage(feature.toCompletionStage()).doOnNext(request -> {
            if (this.headers != null) {
                this.headers.forEach(request::putHeader);
            }
            if (headers2 != null) {
                headers2.forEach(request::putHeader);
            }
        }).flatMap(res -> Mono.fromCompletionStage(((Future)sender.apply((HttpClientRequest)res)).toCompletionStage()).flatMap(response -> {
            HttpHeaders head = new HttpHeaders();
            response.headers().forEach(head::add);
            return Mono.fromCompletionStage(response.body().toCompletionStage()).map(body2 -> {
                this.received(body2.length());
                HttpStatus status = HttpStatus.valueOf(response.statusCode());
                this.incr(HTTPClient.statusCountAttr(status));
                return new HttpResponse(response.version(), status, (Buffer)body2, head);
            });
        }).doAfterTerminate(res::end)).doOnError(this::error);
    }

    private String getPath(String path2) {
        if (path2 == null) {
            return this.basePath;
        }
        if (path2.startsWith("http://") || path2.startsWith("https://")) {
            return path2;
        }
        if (!path2.startsWith("/")) {
            return this.basePath + "/" + path2;
        }
        return this.basePath + path2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public NetworkType getType() {
        return NetworkType.http_client;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    protected void doDisposed() {
        super.doDisposed();
        this.address.release();
        this.client.close();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

