/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import java.time.Duration;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public abstract class FullScreenCommand
extends CommonCommand {
    private static final Logger log = LoggerFactory.getLogger(FullScreenCommand.class);
    protected static final AttributedStyle green = AttributedStyle.BOLD.foreground(2);
    protected static final AttributedStyle blue = AttributedStyle.BOLD.foreground(4);
    protected static final AttributedStyle red = AttributedStyle.BOLD.foreground(1);
    protected Display display;
    private KeyMap<Operation> keys;
    protected BindingReader bindingReader;
    protected Terminal terminal;
    protected final Size size = new Size();
    protected Disposable disposable;
    static final ThreadLocal<AttributedStringBuilder> LINE_BUILDER = ThreadLocal.withInitial(AttributedStringBuilder::new);
    static String[] formats = new String[]{"B", "KB", "MB", "GB"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.terminal = this.main().getTerminal();
        this.bindingReader = new BindingReader(this.terminal.reader());
        this.keys = new KeyMap();
        this.bindKey();
        this.display = new Display(this.terminal, true);
        int delay = 500;
        this.init();
        Terminal.SignalHandler prevHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
        Attributes attr = this.terminal.getAttributes();
        Throwable[] error = new Throwable[1];
        try {
            Attributes newAttr = new Attributes(attr);
            newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
            newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
            newAttr.setControlChar(Attributes.ControlChar.VMIN, 0);
            newAttr.setControlChar(Attributes.ControlChar.VTIME, 1);
            newAttr.setControlChar(Attributes.ControlChar.VINTR, 0);
            this.terminal.setAttributes(newAttr);
            if (!this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0])) {
                this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
            }
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.size.copy(this.terminal.getSize());
            this.display.resize(this.size.getRows(), this.size.getColumns());
            this.disposable = Flux.interval(Duration.ofMillis(delay), Schedulers.boundedElastic()).onBackpressureDrop().limitRate(1).doOnNext(ignore -> {
                try {
                    Size tSize = this.terminal.getSize();
                    if (tSize.getRows() > 0 && tSize.getColumns() > 0 && !tSize.equals(this.size)) {
                        this.size.copy(tSize);
                        this.display.resize(this.size.getRows(), this.size.getColumns());
                        this.display.clear();
                    }
                    this.display();
                }
                catch (Throwable err) {
                    error[0] = err;
                }
            }).subscribe();
            this.display();
            do {
                this.checkInterrupted();
                Operation op = this.bindingReader.readBinding(this.keys);
                if (op == null) continue;
                if (op == DefaultOperation.EXIT) {
                    break;
                }
                if (op == DefaultOperation.CLEAR) {
                    this.display.clear();
                    break;
                }
                if (!this.doOn(op)) {
                    break;
                }
                this.display();
            } while (error[0] == null);
        }
        catch (InterruptedException newAttr) {
        }
        catch (Throwable err) {
            error[0] = err;
        }
        finally {
            this.disposable.dispose();
            this.destroy();
            this.display.clear();
            this.terminal.setAttributes(attr);
            if (prevHandler != null) {
                this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
            }
            if (!this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0])) {
                this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
            }
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            this.terminal.flush();
            if (null != error[0]) {
                log.error("", ExceptionUtils.tryGetRealError(error[0]));
            }
        }
    }

    protected boolean doOn(Operation operation) {
        return true;
    }

    protected void bindDefault(KeyMap<Operation> keys) {
        keys.bind((Operation)DefaultOperation.EXIT, "q", ":q", "Q", ":Q", "ZZ");
        keys.bind((Operation)DefaultOperation.CLEAR, (CharSequence)KeyMap.ctrl('L'));
    }

    private KeyMap<Operation> getKeyMap() {
        return this.keys;
    }

    private void handle(Terminal.Signal signal) {
        int prevw = this.size.getColumns();
        this.size.copy(this.terminal.getSize());
        try {
            if (this.size.getColumns() < prevw) {
                this.display.clear();
            }
            this.display();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void init() {
    }

    protected void destroy() {
    }

    protected abstract boolean display();

    public static AttributedString createLine(Consumer<AttributedStringBuilder> consumer) {
        AttributedStringBuilder builder = LINE_BUILDER.get();
        try {
            consumer.accept(builder);
            AttributedString attributedString = builder.toAttributedString();
            return attributedString;
        }
        finally {
            builder.setLength(0);
        }
    }

    protected void bindKey() {
        this.bindDefault(this.keys);
    }

    private void checkInterrupted() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected static String formatBytes(long bytes) {
        float total;
        int i2 = 0;
        for (total = (float)bytes; total >= 1024.0f && i2 < formats.length - 1; total /= 1024.0f, ++i2) {
        }
        return String.format("%.2f%s", Float.valueOf(total), formats[i2]);
    }

    public static enum DefaultOperation implements Operation
    {
        EXIT,
        CLEAR;

    }

    protected static interface Operation {
    }
}

