/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.multipart.MultipartContext;
import org.synchronoss.cloud.nio.multipart.NioMultipartParser;
import org.synchronoss.cloud.nio.multipart.NioMultipartParserListener;
import org.synchronoss.cloud.nio.multipart.PartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.util.collect.AbstractIterator;
import org.synchronoss.cloud.nio.multipart.util.collect.CloseableIterator;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class BlockingIOAdapter {
    private static final Logger log = LoggerFactory.getLogger(BlockingIOAdapter.class);

    public static CloseableIterator<ParserToken> parse(InputStream inputStream, MultipartContext multipartContext) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, null, 16384, 16384, 1);
    }

    public static CloseableIterator<ParserToken> parse(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, partBodyStreamStorageFactory, 16384, 16384, 1);
    }

    public static CloseableIterator<ParserToken> parse(InputStream inputStream, MultipartContext multipartContext, int bufferSize) {
        return BlockingIOAdapter.parse(inputStream, multipartContext, null, bufferSize, 16384, 1);
    }

    public static CloseableIterator<ParserToken> parse(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory, int bufferSize, int maxHeadersSectionSize, int maxLevelOfNestedMultipart) {
        return new PartItemsIterator(inputStream, multipartContext, partBodyStreamStorageFactory, bufferSize, maxHeadersSectionSize, maxLevelOfNestedMultipart);
    }

    public static class Part
    implements ParserToken {
        final Map<String, List<String>> headers;
        final StreamStorage partBodyStreamStorage;

        private Part(Map<String, List<String>> headers2, StreamStorage partBodyStreamStorage) {
            this.headers = headers2;
            this.partBodyStreamStorage = partBodyStreamStorage;
        }

        @Override
        public ParserToken.Type getType() {
            return ParserToken.Type.PART;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public InputStream getPartBody() {
            return this.partBodyStreamStorage.getInputStream();
        }
    }

    public static class NestedStart
    implements ParserToken {
        final Map<String, List<String>> headers;

        private NestedStart(Map<String, List<String>> headers2) {
            this.headers = headers2;
        }

        @Override
        public ParserToken.Type getType() {
            return ParserToken.Type.NESTED_START;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }
    }

    public static class NestedEnd
    implements ParserToken {
        private NestedEnd() {
        }

        @Override
        public ParserToken.Type getType() {
            return ParserToken.Type.NESTED_END;
        }
    }

    public static interface ParserToken {
        public Type getType();

        public static enum Type {
            PART,
            NESTED_START,
            NESTED_END;

        }
    }

    static class PartItemsIterator
    extends AbstractIterator<ParserToken>
    implements CloseableIterator<ParserToken> {
        private static final ParserToken END_OF_DATA = new ParserToken(){

            @Override
            public ParserToken.Type getType() {
                return null;
            }
        };
        private Queue<ParserToken> parserTokens = new ConcurrentLinkedQueue<ParserToken>();
        private final NioMultipartParser parser;
        private final InputStream inputStream;

        public PartItemsIterator(InputStream inputStream, MultipartContext multipartContext, PartBodyStreamStorageFactory partBodyStreamStorageFactory, int bufferSize, int maxHeadersSectionSize, int maxLevelOfNestedMultipart) {
            this.inputStream = inputStream;
            NioMultipartParserListener listener = new NioMultipartParserListener(){

                @Override
                public void onPartFinished(StreamStorage partBodyStreamStorage, Map<String, List<String>> headersFromPart) {
                    PartItemsIterator.this.parserTokens.add(new Part(headersFromPart, partBodyStreamStorage));
                }

                @Override
                public void onAllPartsFinished() {
                    PartItemsIterator.this.parserTokens.add(END_OF_DATA);
                }

                @Override
                public void onNestedPartStarted(Map<String, List<String>> headersFromParentPart) {
                    PartItemsIterator.this.parserTokens.add(new NestedStart(headersFromParentPart));
                }

                @Override
                public void onNestedPartFinished() {
                    PartItemsIterator.this.parserTokens.add(new NestedEnd());
                }

                @Override
                public void onError(String message, Throwable cause) {
                    throw new IllegalStateException("Error parsing the multipart stream: " + message, cause);
                }
            };
            this.parser = new NioMultipartParser(multipartContext, listener, partBodyStreamStorageFactory, bufferSize, maxHeadersSectionSize, maxLevelOfNestedMultipart);
        }

        @Override
        protected ParserToken computeNext() {
            byte[] buffer = new byte[1024];
            try {
                int read;
                ParserToken next = this.parserTokens.poll();
                if (next != null && next.getType() == null) {
                    return (ParserToken)this.endOfData();
                }
                if (next != null) {
                    return next;
                }
                while (null == (next = this.parserTokens.poll()) && -1 != (read = this.inputStream.read(buffer))) {
                    this.parser.write(buffer, 0, read);
                }
                if (next != null && next.getType() == null) {
                    return (ParserToken)this.endOfData();
                }
                if (next != null) {
                    return next;
                }
                throw new IllegalStateException("Error parsing the multipart stream. Stream ended unexpectedly");
            }
            catch (Exception e) {
                throw new IllegalStateException("Error parsing the multipart stream", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.parser.close();
        }
    }
}

