/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.ThingMessageReply;

public class CommonThingMessageReply<SELF extends CommonThingMessageReply<SELF>>
extends GenericHeaderSupport<SELF>
implements ThingMessageReply {
    private static final long serialVersionUID = -6849794470754667710L;
    private boolean success = true;
    private String code;
    private String message;
    private String messageId;
    private String thingType;
    private String thingId;
    private long timestamp = System.currentTimeMillis();

    @Override
    public ThingMessageReply thingId(String type, String thingId) {
        this.thingType = type;
        this.thingId = thingId;
        return this;
    }

    public SELF code(String code) {
        this.code = code;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF message(String message) {
        this.message = message;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF thingId(String thingId) {
        this.thingId = thingId;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF success() {
        this.success = true;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF success(boolean success) {
        this.success = success;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF error(Throwable e) {
        this.success = false;
        if (e instanceof DeviceOperationException) {
            this.error(((DeviceOperationException)e).getCode());
        } else {
            this.error(ErrorCode.SYSTEM_ERROR);
        }
        this.setMessage(e.getMessage());
        this.addHeader("errorType", (Object)e.getClass().getName());
        this.addHeader("errorMessage", (Object)e.getMessage());
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF error(ErrorCode errorCode) {
        this.success = false;
        this.code = errorCode.name();
        this.message = errorCode.getText();
        this.timestamp = System.currentTimeMillis();
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF from(Message message) {
        this.messageId = message.getMessageId();
        if (message instanceof ThingMessage) {
            this.thingId = ((ThingMessage)message).getThingId();
            this.thingType = ((ThingMessage)message).getThingType();
        }
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF messageId(String messageId) {
        this.messageId = messageId;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    public SELF timestamp(long timestamp) {
        this.timestamp = timestamp;
        return (SELF)((CommonThingMessageReply)this.castSelf());
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = FastBeanCopier.copy(this, JSONObject::new, new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONObject headers2;
        FastBeanCopier.copy(jsonObject, this, "headers");
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        if (null != (headers2 = jsonObject.getJSONObject("headers"))) {
            headers2.forEach(this::addHeader);
        }
    }

    public String toString() {
        return this.toJson().toJSONString();
    }

    public SELF copy() {
        return (SELF)((CommonThingMessageReply)ThingMessageReply.super.copy());
    }

    public static <SELF extends CommonThingMessageReply<SELF>> CommonThingMessageReplyBuilder<SELF> builder() {
        return new CommonThingMessageReplyBuilder();
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String getThingType() {
        return this.thingType;
    }

    @Override
    public String getThingId() {
        return this.thingId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setThingType(String thingType) {
        this.thingType = thingType;
    }

    public void setThingId(String thingId) {
        this.thingId = thingId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public CommonThingMessageReply(boolean success, String code, String message, String messageId, String thingType, String thingId, long timestamp) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.messageId = messageId;
        this.thingType = thingType;
        this.thingId = thingId;
        this.timestamp = timestamp;
    }

    public CommonThingMessageReply() {
    }

    public static class CommonThingMessageReplyBuilder<SELF extends CommonThingMessageReply<SELF>> {
        private boolean success;
        private String code;
        private String message;
        private String messageId;
        private String thingType;
        private String thingId;
        private long timestamp;

        CommonThingMessageReplyBuilder() {
        }

        public CommonThingMessageReplyBuilder<SELF> success(boolean success) {
            this.success = success;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> code(String code) {
            this.code = code;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> message(String message) {
            this.message = message;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> thingType(String thingType) {
            this.thingType = thingType;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public CommonThingMessageReplyBuilder<SELF> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CommonThingMessageReply<SELF> build() {
            return new CommonThingMessageReply(this.success, this.code, this.message, this.messageId, this.thingType, this.thingId, this.timestamp);
        }

        public String toString() {
            return "CommonThingMessageReply.CommonThingMessageReplyBuilder(success=" + this.success + ", code=" + this.code + ", message=" + this.message + ", messageId=" + this.messageId + ", thingType=" + this.thingType + ", thingId=" + this.thingId + ", timestamp=" + this.timestamp + ")";
        }
    }
}

