/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.springframework.context.index.processor.StereotypesProvider;
import org.springframework.context.index.processor.TypeHelper;

class IndexedStereotypesProvider
implements StereotypesProvider {
    private static final String INDEXED_ANNOTATION = "org.springframework.stereotype.Indexed";
    private final TypeHelper typeHelper;

    public IndexedStereotypesProvider(TypeHelper typeHelper) {
        this.typeHelper = typeHelper;
    }

    @Override
    public Set<String> getStereotypes(Element element) {
        LinkedHashSet<String> stereotypes = new LinkedHashSet<String>();
        ElementKind kind = element.getKind();
        if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE) {
            return stereotypes;
        }
        HashSet<Element> seen = new HashSet<Element>();
        this.collectStereotypesOnAnnotations(seen, stereotypes, element);
        seen = new HashSet();
        this.collectStereotypesOnTypes(seen, stereotypes, element);
        return stereotypes;
    }

    private void collectStereotypesOnAnnotations(Set<Element> seen, Set<String> stereotypes, Element element) {
        for (AnnotationMirror annotationMirror : this.typeHelper.getAllAnnotationMirrors(element)) {
            Element next = this.collectStereotypes(seen, stereotypes, element, annotationMirror);
            if (next == null) continue;
            this.collectStereotypesOnAnnotations(seen, stereotypes, next);
        }
    }

    private void collectStereotypesOnTypes(Set<Element> seen, Set<String> stereotypes, Element type) {
        if (!seen.contains(type)) {
            Element superClass;
            seen.add(type);
            if (this.isAnnotatedWithIndexed(type)) {
                stereotypes.add(this.typeHelper.getType(type));
            }
            if ((superClass = this.typeHelper.getSuperClass(type)) != null) {
                this.collectStereotypesOnTypes(seen, stereotypes, superClass);
            }
            this.typeHelper.getDirectInterfaces(type).forEach(i2 -> this.collectStereotypesOnTypes(seen, stereotypes, (Element)i2));
        }
    }

    private Element collectStereotypes(Set<Element> seen, Set<String> stereotypes, Element element, AnnotationMirror annotation) {
        if (this.isIndexedAnnotation(annotation)) {
            stereotypes.add(this.typeHelper.getType(element));
        }
        return this.getCandidateAnnotationElement(seen, annotation);
    }

    private Element getCandidateAnnotationElement(Set<Element> seen, AnnotationMirror annotation) {
        Element element = annotation.getAnnotationType().asElement();
        if (seen.contains(element)) {
            return null;
        }
        if (!this.isIndexedAnnotation(annotation)) {
            seen.add(element);
        }
        return !element.toString().startsWith("java.lang") ? element : null;
    }

    private boolean isAnnotatedWithIndexed(Element type) {
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!this.isIndexedAnnotation(annotationMirror)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndexedAnnotation(AnnotationMirror annotation) {
        return INDEXED_ANNOTATION.equals(annotation.getAnnotationType().toString());
    }
}

