/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.script.context;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import org.jetlinks.simulator.core.script.context.DefaultExecutionContext;
import org.jetlinks.simulator.core.script.context.ExecutionContext;

public class CompositeExecutionContext
implements ExecutionContext {
    private ExecutionContext[] contexts;

    @Override
    public synchronized ExecutionContext merge(ExecutionContext target) {
        this.contexts = Arrays.copyOf(this.contexts, this.contexts.length + 1);
        this.contexts[this.contexts.length - 1] = target;
        return this;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
    }

    @Override
    public Bindings getBindings(int scope) {
        return null;
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.contexts[this.contexts.length - 1].setAttribute(name, value, scope);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getAttribute(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        for (ExecutionContext context : this.contexts) {
            if (!context.hasAttribute(name)) continue;
            return context.removeAttribute(name, scope);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        for (ExecutionContext context : this.contexts) {
            if (!context.hasAttribute(name)) continue;
            return context.getAttribute(name);
        }
        return null;
    }

    @Override
    public int getAttributesScope(String name) {
        for (ExecutionContext context : this.contexts) {
            if (!context.hasAttribute(name)) continue;
            return context.getAttributesScope(name);
        }
        return 100;
    }

    @Override
    public boolean hasAttribute(String key) {
        for (ExecutionContext context : this.contexts) {
            if (!context.hasAttribute(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer getWriter() {
        for (ExecutionContext context : this.contexts) {
            Writer writer = context.getWriter();
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public Writer getErrorWriter() {
        for (ExecutionContext context : this.contexts) {
            Writer writer = context.getErrorWriter();
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public void setWriter(Writer writer) {
    }

    @Override
    public void setErrorWriter(Writer writer) {
    }

    @Override
    public Reader getReader() {
        for (ExecutionContext context : this.contexts) {
            Reader reader = context.getReader();
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    @Override
    public void setReader(Reader reader) {
    }

    @Override
    public List<Integer> getScopes() {
        return DefaultExecutionContext.scopes;
    }

    public CompositeExecutionContext(ExecutionContext[] contexts) {
        this.contexts = contexts;
    }
}

