/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.report;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.simulator.core.report.Reporter;

class DefaultReporter
implements Reporter {
    private final Map<String, List<PointImpl>> points = new ConcurrentHashMap<String, List<PointImpl>>();
    static Duration[] distArray = new Duration[]{Duration.ofSeconds(5L), Duration.ofSeconds(1L), Duration.ofMillis(500L), Duration.ofMillis(100L), Duration.ofMillis(10L), Duration.ofMillis(1L)};

    DefaultReporter() {
    }

    public List<PointImpl> points(String name) {
        return this.points.computeIfAbsent(name, ignore -> new CopyOnWriteArrayList());
    }

    @Override
    public Reporter.Point newPoint(String name) {
        PointImpl point = new PointImpl();
        this.points(name).add(point);
        return point;
    }

    @Override
    public Map<String, Reporter.Aggregate> aggregates() {
        HashMap<String, Reporter.Aggregate> aggregateMap = new HashMap<String, Reporter.Aggregate>();
        for (Map.Entry<String, List<PointImpl>> stringListEntry : this.points.entrySet()) {
            AggregateImpl impl = new AggregateImpl();
            stringListEntry.getValue().forEach(impl::update);
            aggregateMap.put(stringListEntry.getKey(), impl);
        }
        return aggregateMap;
    }

    @Override
    public Reporter.Aggregate aggregate(String name) {
        AggregateImpl impl = new AggregateImpl();
        this.points.getOrDefault(name, Collections.emptyList()).forEach(impl::update);
        return impl;
    }

    static class PointImpl
    implements Reporter.Point {
        private long startWithNanos;
        private long endWithNanos;
        private boolean error;
        private String errorMessage;

        PointImpl() {
        }

        @Override
        public void start() {
            this.startWithNanos = System.nanoTime();
        }

        @Override
        public void success() {
            this.endWithNanos = System.nanoTime();
        }

        @Override
        public void error(String message) {
            this.endWithNanos = System.nanoTime();
            this.error = this.error;
            this.errorMessage = message;
        }

        public long getStartWithNanos() {
            return this.startWithNanos;
        }

        public long getEndWithNanos() {
            return this.endWithNanos;
        }

        public boolean isError() {
            return this.error;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    static class AggregateImpl
    implements Reporter.Aggregate {
        int total;
        int executing;
        long totalTimeNanos;
        Map<Duration, Long> distribution = new TreeMap<Duration, Long>(Comparator.comparingLong(Duration::toNanos).reversed());

        AggregateImpl() {
        }

        public void update(PointImpl point) {
            if (point.endWithNanos == 0L) {
                ++this.executing;
                return;
            }
            ++this.total;
            long useNanos = point.endWithNanos - point.startWithNanos;
            for (Duration duration : distArray) {
                if (useNanos < duration.toNanos()) continue;
                this.distribution.compute(duration, (ignore, x) -> x == null ? 1L : x + 1L);
                break;
            }
            this.totalTimeNanos += useNanos;
        }

        @Override
        public int getTotal() {
            return this.total;
        }

        @Override
        public int getExecuting() {
            return this.executing;
        }

        @Override
        public long getTotalTimeNanos() {
            return this.totalTimeNanos;
        }

        @Override
        public Map<Duration, Long> getDistribution() {
            return this.distribution;
        }
    }
}

