/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network.http;

import io.vertx.core.http.HttpClientOptions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;

public class HTTPClientOptions
extends HttpClientOptions {
    private String id;
    private String basePath;
    private HttpHeaders headers;

    public HTTPClientOptions() {
    }

    public HTTPClientOptions(HTTPClientOptions options) {
        super(options);
        this.id = options.id;
        this.basePath = options.getBasePath();
        this.headers = options.getHeaders();
    }

    public HTTPClientOptions copy() {
        return new HTTPClientOptions(this);
    }

    private HTTPClientOptions apply(Map<String, Object> args) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            String key = "{" + entry.getKey() + "}";
            String value = String.valueOf(entry.getValue());
            if (this.id != null) {
                this.id = this.id.replace(key, value);
            }
            if (this.basePath != null) {
                this.basePath = this.basePath.replace(key, value);
            }
            if (this.headers == null) continue;
            for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
                e.setValue(e.getValue().stream().map(str -> str.replace(key, value)).collect(Collectors.toList()));
            }
        }
        return this;
    }

    public HTTPClientOptions refactor(Map<String, Object> args) {
        return this.copy().apply(args);
    }

    public String getId() {
        return this.id;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setHeaders(HttpHeaders headers2) {
        this.headers = headers2;
    }
}

