/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.benchmark;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.AttachCommand;
import org.jetlinks.simulator.cmd.CommonCommand;
import org.jetlinks.simulator.cmd.ListConnection;
import org.jetlinks.simulator.cmd.benchmark.BenchmarkListCommand;
import org.jetlinks.simulator.cmd.benchmark.HTTPBenchMark;
import org.jetlinks.simulator.cmd.benchmark.MQTTBenchMark;
import org.jetlinks.simulator.cmd.benchmark.TCPBenchMark;
import org.jetlinks.simulator.cmd.benchmark.UDPBenchMark;
import org.jetlinks.simulator.core.CompositeConnectionManager;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.ConnectionManager;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.benchmark.Benchmark;
import org.jetlinks.simulator.core.benchmark.BenchmarkOptions;
import org.jetlinks.simulator.core.monitor.SystemMonitor;
import org.jetlinks.simulator.core.report.Reporter;
import org.jetlinks.simulator.history.CommandHistory;
import org.jline.reader.History;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="benchmark", description={"Run Benchmark"}, headerHeading="%n", subcommands={MQTTBenchMark.class, StatsCommand.class, BenchmarkListCommand.class, TCPBenchMark.class, UDPBenchMark.class, HTTPBenchMark.class})
public class BenchmarkCommand
extends CommonCommand
implements Runnable {
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    static Map<String, Benchmark> allBenchMark = new ConcurrentHashMap<String, Benchmark>();
    static Map<String, Integer> benchmarkNameIndex = new ConcurrentHashMap<String, Integer>();

    public static void addBenchmark(Benchmark benchmark) {
        Benchmark old = allBenchMark.put(benchmark.getName(), benchmark);
        if (null != old) {
            old.dispose();
        }
    }

    public static String createBenchmarkName(String name) {
        if (allBenchMark.containsKey(name)) {
            return name + "_" + benchmarkNameIndex.compute(name, (ignore, i2) -> i2 == null ? 2 : i2 + 1);
        }
        return name;
    }

    @Override
    public void run() {
        this.showHelp();
    }

    public static class Options
    extends BenchmarkOptions {
        @Override
        @CommandLine.Option(names={"--name"}, description={"Set Unique name"}, order=90)
        public void setName(String name) {
            super.setName(name);
        }

        @Override
        @CommandLine.Option(names={"--index"}, description={"Start index"}, defaultValue="0", order=100)
        public void setIndex(int index) {
            super.setIndex(index);
        }

        @Override
        @CommandLine.Option(names={"--size"}, description={"Number of create"}, defaultValue="1", order=101)
        public void setSize(int size) {
            super.setSize(size);
        }

        @Override
        @CommandLine.Option(names={"--concurrency"}, description={"Concurrency"}, defaultValue="8", order=102)
        public void setConcurrency(int concurrency) {
            super.setConcurrency(concurrency);
        }

        @Override
        @CommandLine.Option(names={"--script"}, description={"Script File"}, order=103)
        public void setFile(File file) {
            super.setFile(file);
        }

        @Override
        @CommandLine.Parameters
        public void setScriptArgs(Map<String, Object> scriptArgs) {
            super.setScriptArgs(scriptArgs);
        }
    }

    @CommandLine.Command(name="stats", description={"Show Benchmark stats"}, headerHeading="%n")
    static class StatsCommand
    extends AttachCommand
    implements Runnable {
        @CommandLine.Parameters(description={"Benchmark name"}, completionCandidates=NameComplete.class)
        private String name;
        private Collection<Benchmark> benchmarks;

        StatsCommand() {
        }

        @Override
        protected History history() {
            if (this.name != null) {
                return CommandHistory.getHistory("benchmark_history_" + this.name);
            }
            return super.history();
        }

        @Override
        protected void doClear() {
            super.doClear();
            if (this.benchmarks != null) {
                for (Benchmark benchmark : this.benchmarks) {
                    benchmark.clear();
                }
            }
        }

        @Override
        protected void init() {
            super.init();
            if (StringUtils.hasText(this.name)) {
                Benchmark benchmark = allBenchMark.get(this.name);
                if (benchmark == null) {
                    throw new IllegalArgumentException("Benchmark [%s] not found");
                }
                this.benchmarks = Collections.singleton(benchmark);
            } else {
                this.benchmarks = allBenchMark.values();
            }
        }

        @Override
        protected void createHeader(List<AttributedString> lines) {
            lines.add(StatsCommand.createLine(builder -> {
                double cpu = SystemMonitor.jvmCpuUsage.value();
                MemoryUsage heap = memoryMXBean.getHeapMemoryUsage();
                double heapUsage = (double)heap.getUsed() / (double)heap.getMax();
                builder.append("JVM CPU: ").append(String.format("%.2f", cpu * 100.0) + "%", cpu > 0.8 ? red : green);
                builder.append(" JVM Mem: ").append(StatsCommand.formatBytes(heap.getUsed()) + "/" + StatsCommand.formatBytes(heap.getMax()), heapUsage > 0.8 ? red : green);
            }));
            for (Benchmark benchmark : this.benchmarks) {
                Deque<Benchmark.Snapshot> snapshots = benchmark.snapshots();
                Benchmark.Snapshot last = snapshots.peekLast();
                Benchmark.Snapshot lastQps = last == null ? null : last.getDiff();
                lines.add(StatsCommand.createLine(builder -> {
                    Reporter.Aggregate connection = benchmark.getReporter().aggregate("connecting");
                    builder.append("Benchmark(").append(benchmark.getName(), green).append(") size: ").append(String.valueOf(benchmark.getOptions().getSize()), green).append(" connecting: ").append(lastQps == null ? "0" : String.valueOf(lastQps.getSummary().getSize()), green).append("/s");
                    builder.append(" Time distribution: ");
                    int i2 = 0;
                    for (Map.Entry<Duration, Long> entry : connection.getDistribution().entrySet()) {
                        if (i2++ > 0) {
                            builder.append(",");
                        }
                        builder.append(String.valueOf(entry.getValue()), green).append(">=").append(String.valueOf(entry.getKey().toMillis())).append("ms");
                    }
                    Throwable lastError = benchmark.getLastError();
                    if (null != lastError) {
                        builder.append(" Last Error: ").append(ExceptionUtils.getErrorMessage(lastError), red);
                    }
                }));
                lines.add(StatsCommand.createLine(builder -> {
                    ConnectionManager.Summary summary = benchmark.getConnectionManager().summary().block();
                    Map statusCount = benchmark.getConnectionManager().getConnections().map(Connection::statusCount).reduce(new LinkedHashMap(), (a, b) -> {
                        b.forEach((key, v) -> a.compute(key.replace("status_", ""), (ignore, old) -> old == null ? v : v + old));
                        return a;
                    }).block();
                    if (summary != null) {
                        builder.append("                ");
                        if (benchmark.isDisposed()) {
                            builder.append("stopped", red);
                        } else {
                            builder.append("alive: ").append(String.valueOf(summary.getConnected()), green);
                        }
                        if (lastQps != null) {
                            builder.append(" sent: ").append(String.valueOf(summary.getSent()), green).append(",").append(String.valueOf(lastQps.getSummary().getSent()), green).append("/s(").append(StatsCommand.formatBytes(summary.getSentBytes()), blue).append(",").append(StatsCommand.formatBytes(lastQps.getSummary().getSentBytes()), blue).append("/s)");
                            builder.append(" received: ").append(String.valueOf(summary.getReceived()), green).append(",").append(String.valueOf(lastQps.getSummary().getReceived()), green).append("/s(").append(StatsCommand.formatBytes(summary.getReceivedBytes()), blue).append(",").append(StatsCommand.formatBytes(lastQps.getSummary().getReceivedBytes()), blue).append("/s)");
                        } else {
                            builder.append(" sent: ").append(String.valueOf(summary.getSent()), green).append("(").append(StatsCommand.formatBytes(summary.getSentBytes()), blue).append(")");
                            builder.append(" received: ").append(String.valueOf(summary.getReceived()), green).append("(").append(StatsCommand.formatBytes(summary.getReceivedBytes()), blue).append(")");
                        }
                    }
                    if (MapUtils.isNotEmpty(statusCount)) {
                        builder.append(" Status:");
                        for (Map.Entry str : statusCount.entrySet()) {
                            builder.append(" ");
                            AttributedStyle style = this.statusIsBad((String)str.getKey()) ? red : green;
                            builder.append((CharSequence)str.getKey(), style).append("(").append(String.valueOf(str.getValue()), blue).append(")");
                        }
                    }
                }));
            }
        }

        public boolean statusIsBad(String status) {
            return !"OK".equals(status) && !"SUCCESS".equals(status);
        }

        @Override
        protected void createBody(List<AttributedString> lines) {
            for (Benchmark benchmark : this.benchmarks) {
                for (String log : benchmark.getLogs()) {
                    for (String l : log.split("\n")) {
                        lines.add(AttributedString.fromAnsi(l));
                    }
                }
            }
        }

        @Override
        protected AbstractCommand createCommand() {
            return new AttachCommands();
        }

        @CommandLine.Command(name="stop", description={"Stop Benchmark"})
        static class Stop
        extends CommonCommand {
            Stop() {
            }

            @Override
            public void run() {
                ((AttachCommands)this.parent).stop();
            }
        }

        @CommandLine.Command(name="reload", description={"Reload Benchmark"})
        static class ReloadCommand
        extends CommonCommand {
            @CommandLine.Option(names={"--script"}, description={"Script File"}, order=1)
            private File file;
            @CommandLine.Parameters(paramLabel="Script arguments")
            Map<String, Object> scriptArgs;
            @CommandLine.Option(names={"--name"}, description={"Benchmark Name"}, order=2, completionCandidates=NameComplete.class)
            private String name;

            ReloadCommand() {
            }

            @Override
            public void run() {
                ((AttachCommands)this.parent).reload(this);
            }
        }

        @CommandLine.Command(name="select", description={"Search connections"}, headerHeading="%n")
        static class ListCommand
        extends ListConnection {
            ListCommand() {
            }

            @Override
            protected ConnectionManager connectionManager() {
                return ((AttachCommands)this.parent).connectionManager();
            }

            @Override
            protected void printf(String template, Object ... args) {
                ((AttachCommands)this.parent).appendBody(String.format(template, args));
            }

            @Override
            protected void printfError(String template, Object ... args) {
                ((AttachCommands)this.parent).appendBody(String.format(template, args));
            }
        }

        @CommandLine.Command(name="", subcommands={ReloadCommand.class, Stop.class, ListCommand.class}, customSynopsis={""}, synopsisHeading="")
        class AttachCommands
        extends CommonCommand {
            AttachCommands() {
            }

            ConnectionManager connectionManager() {
                return new CompositeConnectionManager(StatsCommand.this.benchmarks.stream().map(Benchmark::getConnectionManager).collect(Collectors.toList()));
            }

            void reload(ReloadCommand command) {
                for (Benchmark benchmark : StatsCommand.this.benchmarks) {
                    if (command.name != null && !Objects.equals(benchmark.getName(), command.name)) continue;
                    if (command.file != null && command.file.isFile() && command.file.exists()) {
                        benchmark.getOptions().setFile(command.file);
                    }
                    if (command.scriptArgs != null) {
                        benchmark.getOptions().setScriptArgs(command.scriptArgs);
                    }
                    try {
                        benchmark.reload();
                    }
                    catch (Throwable err) {
                        this.printfError("reload error:%s%n", ExceptionUtils.getErrorMessage(err));
                    }
                }
            }

            void stop() {
                for (Benchmark benchmark : StatsCommand.this.benchmarks) {
                    benchmark.dispose();
                }
            }

            void appendBody(String str) {
                block0: {
                    Iterator iterator = StatsCommand.this.benchmarks.iterator();
                    if (!iterator.hasNext()) break block0;
                    Benchmark benchmark = (Benchmark)iterator.next();
                    benchmark.getLogs().add(str);
                }
            }
        }
    }

    static class NameComplete
    implements Iterable<String> {
        NameComplete() {
        }

        @Override
        public Iterator<String> iterator() {
            return allBenchMark.keySet().iterator();
        }
    }
}

