/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import org.jetlinks.simulator.cli.StandardHelpOptions;
import org.jetlinks.simulator.cmd.SimulatorCommands;
import picocli.CommandLine;

public abstract class AbstractCommand {
    @CommandLine.ParentCommand
    protected Object parent;
    @CommandLine.Mixin
    StandardHelpOptions options = new StandardHelpOptions();
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected void setParent(Object parent) {
        this.parent = parent;
    }

    public SimulatorCommands main() {
        if (this.parent instanceof SimulatorCommands) {
            return (SimulatorCommands)this.parent;
        }
        if (this.parent instanceof AbstractCommand) {
            return ((AbstractCommand)this.parent).main();
        }
        throw new UnsupportedOperationException();
    }

    protected void showHelp() {
        if (this.spec != null) {
            this.main().getCommandLine().execute(this.spec.name(), "--help");
        }
    }

    protected void printf(String template, Object ... args) {
        if (this.parent instanceof AbstractCommand) {
            ((AbstractCommand)this.parent).printf(template, args);
            return;
        }
        this.main().printf(template, args).flush();
    }

    protected void printfError(String template, Object ... args) {
        if (this.parent instanceof AbstractCommand) {
            ((AbstractCommand)this.parent).printfError(template, args);
            return;
        }
        this.main().printfError(template, args).flush();
    }

    public Object getParent() {
        return this.parent;
    }
}

