/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator;

import java.io.PrintWriter;
import org.jetlinks.simulator.cli.InteractiveCLI;
import org.jetlinks.simulator.cli.SimulatorCli;
import org.jetlinks.simulator.cmd.SimulatorCommands;
import picocli.CommandLine;

public class Main {
    public static void main(String[] args) {
        SimulatorCli cli = new SimulatorCli();
        CommandLine command = new CommandLine(cli);
        int exitCode = command.execute(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        if (command.isUsageHelpRequested() || command.isVersionHelpRequested()) {
            System.exit(0);
        }
        try {
            SimulatorCommands commands = new SimulatorCommands();
            InteractiveCLI console = new InteractiveCLI(commands);
            console.showHelp();
            console.start();
            commands.dispose();
            System.exit(1);
        }
        catch (Exception e) {
            PrintWriter printer = command.getErr();
            printer.print(command.getColorScheme().errorText("Unable to create and start simulator ..."));
            printer.printf("%n%n", new Object[0]);
            printer.print(command.getColorScheme().stackTraceText(e));
            printer.flush();
            System.exit(1);
        }
    }
}

