/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.filter;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class IfValueMapFeature
implements ValueMapFeature {
    private static final String ID = FeatureId.ValueMap.of("if").getId();

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        List<Expression> expressions;
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        if (function.getParameters() == null || CollectionUtils.isEmpty(expressions = function.getParameters().getExpressions()) || expressions.size() < 2) {
            throw new IllegalArgumentException("\u51fd\u6570\u53c2\u6570\u6570\u91cf\u5fc5\u987b>=2:" + expression);
        }
        BiFunction<ReactorQLRecord, Object, Mono<Boolean>> ifPredicate = FilterFeature.createPredicateNow(expressions.get(0), metadata);
        Function<ReactorQLRecord, Publisher<?>> ifMapper = ValueMapFeature.createMapperNow(expressions.get(1), metadata);
        Function<ReactorQLRecord, Publisher> elseMapper = expressions.size() == 3 ? ValueMapFeature.createMapperNow(expressions.get(2), metadata) : record -> Mono.empty();
        return row -> Mono.from((Publisher)ifPredicate.apply((ReactorQLRecord)row, row)).defaultIfEmpty(false).flatMap(matched -> {
            if (matched.booleanValue()) {
                return Mono.from((Publisher)ifMapper.apply((ReactorQLRecord)row));
            }
            return Mono.from((Publisher)elseMapper.apply((ReactorQLRecord)row));
        });
    }

    @Override
    public String getId() {
        return ID;
    }
}

