/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.utils.SqlUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultReactorQLContext
implements ReactorQLContext {
    private final Function<String, Flux<Object>> supplier;
    private final List<Object> parameter = new ArrayList<Object>();
    private final Map<String, Object> namedParameter = new HashMap<String, Object>();
    private BiFunction<String, Flux<Object>, Flux<Object>> mapper = (s2, flux) -> flux;

    public DefaultReactorQLContext(Function<String, ? extends Publisher<?>> supplier) {
        this.supplier = name -> Flux.from((Publisher)supplier.apply((String)name));
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.namedParameter;
    }

    @Override
    public ReactorQLContext bind(Object value) {
        this.parameter.add(value);
        return this;
    }

    @Override
    public ReactorQLContext bind(int index, Object value) {
        this.parameter.add(index, value);
        return this;
    }

    @Override
    public ReactorQLContext bind(String name, Object value) {
        if (name != null && value != null) {
            this.namedParameter.put(name, value);
        }
        return this;
    }

    @Override
    public Flux<Object> getDataSource(String name) {
        name = SqlUtils.getCleanStr(name);
        return this.mapper.apply(name, this.supplier.apply(name));
    }

    @Override
    public Optional<Object> getParameter(int index) {
        if (this.parameter.size() <= index) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.parameter.get(index));
    }

    @Override
    public Optional<Object> getParameter(String name) {
        return Optional.ofNullable(this.namedParameter.get(SqlUtils.getCleanStr(name)));
    }

    @Override
    public ReactorQLContext transfer(BiFunction<String, Flux<Object>, Flux<Object>> dataSourceMapper) {
        DefaultReactorQLContext context = new DefaultReactorQLContext(this.supplier);
        context.mapper = dataSourceMapper;
        return context;
    }
}

