/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.DefaultReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQL;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.FromFeature;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.feature.ValueAggMapFeature;
import org.jetlinks.reactor.ql.feature.ValueFlatMapFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.jetlinks.reactor.ql.supports.DefaultReactorQLMetadata;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.reactor.ql.utils.CompareUtils;
import org.jetlinks.reactor.ql.utils.ExpressionUtils;
import org.jetlinks.reactor.ql.utils.SqlUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;
import reactor.util.context.Context;
import reactor.util.function.Tuples;

public class DefaultReactorQL
implements ReactorQL {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactorQL.class);
    private static final String GROUP_NAME_CONTEXT_KEY = "named-group";
    private static final Mono<Boolean> alwaysTrue = Mono.just(true);
    private static final Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> rowInfoWrapper = flux -> flux.elapsed().index((index, row) -> {
        HashMap<String, Long> rowInfo = new HashMap<String, Long>();
        rowInfo.put("index", index + 1L);
        rowInfo.put("elapsed", (Long)row.getT1());
        ((ReactorQLRecord)row.getT2()).addRecord("row", rowInfo);
        return (ReactorQLRecord)row.getT2();
    });
    private final ReactorQLMetadata metadata;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> columnMapper;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> join;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> where;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> groupBy;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> orderBy;
    private BiFunction<ReactorQLContext, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> limit;
    private BiFunction<ReactorQLContext, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> offset;
    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> distinct;
    private Function<ReactorQLContext, Flux<ReactorQLRecord>> builder;

    public DefaultReactorQL(ReactorQLMetadata metadata) {
        this.metadata = metadata;
        this.prepare();
    }

    protected void prepare() {
        this.where = this.createWhere();
        this.columnMapper = this.createMapper();
        this.limit = this.createLimit();
        this.offset = this.createOffset();
        this.groupBy = this.createGroupBy();
        this.join = this.createJoin();
        this.orderBy = this.createOrderBy();
        this.distinct = this.createDistinct();
        Function<ReactorQLContext, Flux<ReactorQLRecord>> fromMapper = FromFeature.createFromMapperByBody(this.metadata.getSql(), this.metadata);
        PlainSelect select = this.metadata.getSql();
        this.builder = null != select.getGroupBy() ? ctx -> this.limit.apply((ReactorQLContext)ctx, this.offset.apply((ReactorQLContext)ctx, this.distinct.apply(this.orderBy.apply(this.groupBy.apply(this.where.apply(this.join.apply(rowInfoWrapper.apply((Flux<ReactorQLRecord>)fromMapper.apply((ReactorQLContext)ctx))))))))) : ctx -> this.limit.apply((ReactorQLContext)ctx, this.offset.apply((ReactorQLContext)ctx, this.distinct.apply(this.orderBy.apply(this.columnMapper.apply(this.where.apply(this.join.apply(rowInfoWrapper.apply((Flux<ReactorQLRecord>)fromMapper.apply((ReactorQLContext)ctx)))))))));
    }

    protected Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createDistinct() {
        Distinct distinct = this.metadata.getSql().getDistinct();
        if (distinct == null) {
            return Function.identity();
        }
        return this.metadata.getFeatureNow(FeatureId.Distinct.of(this.metadata.getSetting("distinctBy").map(String::valueOf).orElse("default"))).createDistinctMapper(distinct, this.metadata);
    }

    protected Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createJoin() {
        if (CollectionUtils.isEmpty(this.metadata.getSql().getJoins())) {
            return Function.identity();
        }
        Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> mapper = Function.identity();
        for (Join joinInfo : this.metadata.getSql().getJoins()) {
            Expression on = joinInfo.getOnExpression();
            FromItem from = joinInfo.getRightItem();
            BiFunction<ReactorQLRecord, Object, Mono> filter2 = on == null ? (ctx, v) -> alwaysTrue : FilterFeature.createPredicateNow(on, this.metadata);
            Function<ReactorQLRecord, Flux> rightStreamGetter = null;
            if (from instanceof SubSelect) {
                String alias = from.getAlias() == null ? null : from.getAlias().getName();
                DefaultReactorQL ql = new DefaultReactorQL(new DefaultReactorQLMetadata((PlainSelect)((SubSelect)from).getSelectBody()));
                rightStreamGetter = record -> ql.builder.apply(record.getContext().transfer((name, flux) -> flux.map(source -> ReactorQLRecord.newRecord(name, source, record.getContext()).addRecords(record.getRecords(false)))).bindAll(record.getRecords(false))).map(v -> record.addRecord(alias, v.asMap()));
            } else if (from instanceof Table) {
                String name = ((Table)from).getFullyQualifiedName();
                String alias = from.getAlias() == null ? name : from.getAlias().getName();
                rightStreamGetter = left -> left.getDataSource(name).map(right -> ReactorQLRecord.newRecord(alias, right, left.getContext()).addRecords(left.getRecords(false)));
            }
            if (rightStreamGetter == null) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8868\u5173\u8054: " + from);
            }
            Function<ReactorQLRecord, Flux> fiRightStreamGetter = rightStreamGetter;
            if (joinInfo.isLeft()) {
                mapper = mapper.andThen(flux -> flux.flatMap(left -> ((Flux)fiRightStreamGetter.apply((ReactorQLRecord)left)).filterWhen(right -> (Mono)filter2.apply((ReactorQLRecord)right, right.getRecord())).defaultIfEmpty((ReactorQLRecord)left), Integer.MAX_VALUE));
                continue;
            }
            if (joinInfo.isRight()) {
                mapper = mapper.andThen(flux -> flux.flatMap(left -> ((Flux)fiRightStreamGetter.apply((ReactorQLRecord)left)).flatMap(right -> ((Mono)filter2.apply((ReactorQLRecord)right, right.getRecord())).map(matched -> matched != false ? right : right.removeRecord(left.getName()))).defaultIfEmpty(left), Integer.MAX_VALUE));
                continue;
            }
            mapper = mapper.andThen(flux -> flux.flatMap(left -> ((Flux)fiRightStreamGetter.apply((ReactorQLRecord)left)).filterWhen(v -> (Mono)filter2.apply((ReactorQLRecord)v, v.getRecord()))));
        }
        return mapper;
    }

    protected Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createGroupBy() {
        PlainSelect select = this.metadata.getSql();
        GroupByElement groupBy = select.getGroupBy();
        if (null != groupBy) {
            AtomicReference groupByRef = new AtomicReference();
            Consumer3<String, Expression, GroupFeature> featureConsumer = (name, expr, feature) -> {
                Function<Flux<ReactorQLRecord>, Flux<Flux<ReactorQLRecord>>> mapper = feature.createGroupMapper((Expression)expr, this.metadata);
                Function<Flux, Flux> nameMapper = flux -> ((Flux)mapper.apply((Flux<ReactorQLRecord>)flux)).map(group -> {
                    if (name != null) {
                        return Tuples.of(group, Collections.singletonMap(name, ((GroupedFlux)group).key()));
                    }
                    return Tuples.of(group, Collections.emptyMap());
                });
                if (groupByRef.get() != null) {
                    groupByRef.set(((Function)groupByRef.get()).andThen(tp2 -> tp2.flatMap(parent -> ((Flux)nameMapper.apply((Flux)parent.getT1())).map(child -> {
                        HashMap zip2 = new HashMap();
                        zip2.putAll((Map)parent.getT2());
                        zip2.putAll((Map)child.getT2());
                        return Tuples.of(child.getT1(), zip2);
                    }), Integer.MAX_VALUE)));
                } else {
                    groupByRef.set(nameMapper);
                }
            };
            for (Expression groupByExpression : groupBy.getGroupByExpressionList().getExpressions()) {
                if (groupByExpression instanceof net.sf.jsqlparser.expression.Function) {
                    featureConsumer.accept(null, groupByExpression, this.metadata.getFeatureNow(FeatureId.GroupBy.of(((net.sf.jsqlparser.expression.Function)groupByExpression).getName()), groupByExpression::toString));
                    continue;
                }
                if (groupByExpression instanceof Column) {
                    featureConsumer.accept(((Column)groupByExpression).getColumnName(), groupByExpression, this.metadata.getFeatureNow(FeatureId.GroupBy.property));
                    continue;
                }
                if (groupByExpression instanceof BinaryExpression) {
                    featureConsumer.accept(null, groupByExpression, this.metadata.getFeatureNow(FeatureId.GroupBy.of(((BinaryExpression)groupByExpression).getStringExpression()), groupByExpression::toString));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported group expression:" + groupByExpression);
            }
            Function groupMapper = (Function)groupByRef.get();
            if (groupMapper != null) {
                Expression having = select.getHaving();
                if (null != having) {
                    BiFunction<ReactorQLRecord, Object, Mono<Boolean>> filter2 = FilterFeature.createPredicateNow(having, this.metadata);
                    return flux -> ((Flux)groupMapper.apply(flux)).flatMap(group -> this.columnMapper.apply((Flux<ReactorQLRecord>)group.getT1()).filterWhen(ctx -> (Mono)filter2.apply((ReactorQLRecord)ctx, ctx.getRecord())).subscriberContext(Context.of(GROUP_NAME_CONTEXT_KEY, group.getT2())), Integer.MAX_VALUE);
                }
                return flux -> ((Flux)groupMapper.apply(flux)).flatMap(group -> this.columnMapper.apply((Flux<ReactorQLRecord>)group.getT1()).subscriberContext(Context.of(GROUP_NAME_CONTEXT_KEY, group.getT2())), Integer.MAX_VALUE);
            }
        }
        return Function.identity();
    }

    protected Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createWhere() {
        Expression whereExpr = this.metadata.getSql().getWhere();
        if (whereExpr == null) {
            return Function.identity();
        }
        BiFunction<ReactorQLRecord, Object, Mono<Boolean>> filter2 = FilterFeature.createPredicateNow(whereExpr, this.metadata);
        return flux -> flux.filterWhen(ctx -> (Mono)filter2.apply((ReactorQLRecord)ctx, ctx.getRecord()));
    }

    protected Optional<Function<ReactorQLRecord, Publisher<?>>> createExpressionMapper(Expression expression) {
        return ValueMapFeature.createMapperByExpression(expression, this.metadata);
    }

    protected Optional<Function<Flux<ReactorQLRecord>, Flux<Object>>> createAggMapper(Expression expression) {
        AtomicReference ref = new AtomicReference();
        Consumer<ValueAggMapFeature> featureConsumer = feature -> {
            Function<Flux<ReactorQLRecord>, Flux<Object>> mapper = feature.createMapper(expression, this.metadata);
            ref.set(mapper);
        };
        if (expression instanceof net.sf.jsqlparser.expression.Function) {
            this.metadata.getFeature(FeatureId.ValueAggMap.of(((net.sf.jsqlparser.expression.Function)expression).getName())).ifPresent(featureConsumer);
        }
        return Optional.ofNullable(ref.get());
    }

    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createMapper() {
        Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> mapper;
        boolean hasMapper;
        final LinkedHashMap mappers = new LinkedHashMap();
        final LinkedHashMap flatMappers = new LinkedHashMap();
        final LinkedHashMap aggMapper = new LinkedHashMap();
        final ArrayList allMapper = new ArrayList();
        for (SelectItem selectItem : this.metadata.getSql().getSelectItems()) {
            selectItem.accept(new SelectItemVisitorAdapter(){

                @Override
                public void visit(SelectExpressionItem item) {
                    Expression expression = item.getExpression();
                    String alias = item.getAlias() == null ? expression.toString() : item.getAlias().getName();
                    String fAlias = SqlUtils.getCleanStr(alias);
                    DefaultReactorQL.this.createExpressionMapper(expression).ifPresent(mapper -> mappers.put(fAlias, mapper));
                    DefaultReactorQL.this.createAggMapper(expression).ifPresent(mapper -> aggMapper.put(fAlias, mapper));
                    ValueFlatMapFeature.createMapperByExpression(expression, DefaultReactorQL.this.metadata).ifPresent(mapper -> flatMappers.put(fAlias, mapper));
                    if (!(mappers.containsKey(fAlias) || aggMapper.containsKey(fAlias) || flatMappers.containsKey(fAlias))) {
                        throw new UnsupportedOperationException("Unsupported expression:" + expression);
                    }
                }

                @Override
                public void visit(AllColumns columns) {
                    allMapper.add(ReactorQLRecord::putRecordToResult);
                }

                @Override
                public void visit(AllTableColumns columns) {
                    Alias alias = columns.getTable().getAlias();
                    String name = alias == null ? SqlUtils.getCleanStr(columns.getTable().getName()) : SqlUtils.getCleanStr(alias.getName());
                    allMapper.add(record -> record.getRecord(name).ifPresent(v -> {
                        if (v instanceof Map) {
                            record.setResults((Map)v);
                        } else {
                            record.setResult(name, v);
                        }
                    }));
                }
            });
        }
        Function<ReactorQLRecord, Mono> _resultMapper = record -> Flux.fromIterable(mappers.entrySet()).flatMap(e -> Mono.zip(Mono.just(e.getKey()), Mono.from((Publisher)((Function)e.getValue()).apply(record)))).doOnNext(tp2 -> record.setResult((String)tp2.getT1(), tp2.getT2())).then().thenReturn(record);
        if (!allMapper.isEmpty()) {
            _resultMapper = _resultMapper.andThen(record -> record.doOnNext(r -> allMapper.forEach(mapper -> mapper.accept(r))));
        }
        Function<ReactorQLRecord, Mono> resultMapper = _resultMapper;
        boolean bl = hasMapper = !mappers.isEmpty();
        if (!aggMapper.isEmpty()) {
            int aggSize = aggMapper.size();
            if (aggSize == 1) {
                String property = (String)aggMapper.keySet().iterator().next();
                Function oneMapper = (Function)aggMapper.values().iterator().next();
                mapper = flux -> {
                    AtomicReference cursor = new AtomicReference();
                    return ((Flux)flux.doOnNext(cursor::set).as(oneMapper)).flatMap(val -> Mono.subscriberContext().flatMap(ctx -> {
                        ReactorQLRecord newCtx = (ReactorQLRecord)cursor.get();
                        newCtx = newCtx == null ? ReactorQLRecord.newRecord(null, new HashMap(), new DefaultReactorQLContext(r -> Flux.just(Integer.valueOf(1)))) : newCtx.copy();
                        newCtx = newCtx.putRecordToResult().resultToRecord(newCtx.getName()).setResult(property, val);
                        newCtx.setResults(ctx.getOrEmpty(GROUP_NAME_CONTEXT_KEY).orElse(Collections.emptyMap()));
                        if (hasMapper) {
                            return (Mono)resultMapper.apply(newCtx);
                        }
                        return Mono.just(newCtx);
                    }));
                };
            } else {
                mapper = flux -> {
                    AtomicReference lastRecordRef = new AtomicReference();
                    Flux<ReactorQLRecord> temp = flux.doOnNext(lastRecordRef::set).publish().refCount(aggSize);
                    return Flux.fromIterable(aggMapper.entrySet()).map(agg -> ((Flux)((Function)agg.getValue()).apply(temp)).map(res -> Tuples.of(agg.getKey(), res))).as(Flux::merge).collect(ConcurrentHashMap::new, (map, nameAndValue) -> {
                        String name = (String)nameAndValue.getT1();
                        Object value = nameAndValue.getT2();
                        map.compute(name, (v1, v2) -> {
                            if (v2 != null) {
                                if (v2 instanceof List) {
                                    ((List)v2).add(value);
                                    return v2;
                                }
                                CopyOnWriteArrayList<Object> values = new CopyOnWriteArrayList<Object>();
                                values.add(v2);
                                values.add(value);
                                return values;
                            }
                            return value;
                        });
                    }).flatMap(map -> Mono.subscriberContext().flatMap(ctx -> {
                        ReactorQLRecord newCtx = (ReactorQLRecord)lastRecordRef.get();
                        if (newCtx == null) {
                            newCtx = ReactorQLRecord.newRecord(null, new HashMap(), new DefaultReactorQLContext(r -> Flux.just(Integer.valueOf(1))));
                        }
                        newCtx = newCtx.putRecordToResult().resultToRecord(newCtx.getName()).setResults((Map<String, Object>)map);
                        newCtx.setResults(ctx.getOrEmpty(GROUP_NAME_CONTEXT_KEY).orElse(Collections.emptyMap()));
                        if (hasMapper) {
                            return (Mono)resultMapper.apply(newCtx);
                        }
                        return Mono.just(newCtx);
                    })).flux();
                };
            }
        } else {
            mapper = this.metadata.getSql().getGroupBy() != null ? flux -> flux.takeLast(1).flatMap(resultMapper) : flux -> flux.flatMap(resultMapper);
        }
        if (flatMappers.isEmpty()) {
            return mapper;
        }
        Function<Flux, Flux> flatMapper = null;
        for (Map.Entry flatMapperEntry : flatMappers.entrySet()) {
            String alias = (String)flatMapperEntry.getKey();
            if (flatMapper == null) {
                flatMapper = flux -> (Flux)((BiFunction)flatMapperEntry.getValue()).apply(alias, flux);
                continue;
            }
            flatMapper = flatMapper.andThen(flux -> (Flux)((BiFunction)flatMapperEntry.getValue()).apply(alias, flux));
        }
        return flatMapper;
    }

    private BiFunction<ReactorQLContext, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createLimit() {
        Limit limit = this.metadata.getSql().getLimit();
        if (limit != null) {
            Expression expr = limit.getRowCount();
            return (ctx, flux) -> {
                Long value = ExpressionUtils.getSimpleValue(expr, ctx).map(val -> CastUtils.castNumber(val).longValue()).orElse(null);
                if (null == value) {
                    return flux;
                }
                return flux.take(value);
            };
        }
        return (ctx, flux) -> flux;
    }

    private BiFunction<ReactorQLContext, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createOffset() {
        Limit limit = this.metadata.getSql().getLimit();
        if (limit != null) {
            Expression expr = limit.getOffset();
            return (ctx, flux) -> {
                Long value = ExpressionUtils.getSimpleValue(expr, ctx).map(val -> CastUtils.castNumber(val).longValue()).orElse(null);
                if (null == value) {
                    return flux;
                }
                return flux.skip(value);
            };
        }
        return (ctx, flux) -> flux;
    }

    private Function<Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createOrderBy() {
        List<OrderByElement> orders = this.metadata.getSql().getOrderByElements();
        if (CollectionUtils.isEmpty(orders)) {
            return Function.identity();
        }
        Comparator comparator = null;
        for (OrderByElement order : orders) {
            Expression expr = order.getExpression();
            Function<ReactorQLRecord, Publisher<?>> mapper = ValueMapFeature.createMapperNow(expr, this.metadata);
            Comparator exprComparator = (left, right) -> Mono.zip(Mono.from((Publisher)mapper.apply((ReactorQLRecord)left)), Mono.from((Publisher)mapper.apply((ReactorQLRecord)right)), CompareUtils::compare).toFuture().getNow(-1);
            if (!order.isAsc()) {
                exprComparator = exprComparator.reversed();
            }
            if (comparator == null) {
                comparator = exprComparator;
                continue;
            }
            comparator = comparator.thenComparing(exprComparator);
        }
        Comparator fiComparator = comparator;
        return flux -> flux.sort(fiComparator);
    }

    @Override
    public Flux<ReactorQLRecord> start(ReactorQLContext context) {
        return this.builder.apply(context);
    }

    @Override
    public Flux<Map<String, Object>> start(Function<String, Publisher<?>> streamSupplier) {
        return this.start(new DefaultReactorQLContext(t -> Flux.from((Publisher)streamSupplier.apply((String)t)))).map(ReactorQLRecord::asMap);
    }

    @Override
    public ReactorQLMetadata metadata() {
        return this.metadata;
    }
}

