/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;

public class ThingTemplateInfo {
    private String id;
    private String name;
    private String metadata;
    private Long version;
    private Map<String, Object> configuration;

    public ThingTemplateInfo addConfig(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.put(key, value);
        return this;
    }

    public ThingTemplateInfo addConfigIfAbsent(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.putIfAbsent(key, value);
        return this;
    }

    public ThingTemplateInfo addConfigs(Map<String, ?> configs) {
        if (configs == null) {
            return this;
        }
        configs.forEach(this::addConfig);
        return this;
    }

    public <T> ThingTemplateInfo addConfig(ConfigKey<T> key, T value) {
        this.addConfig(key.getKey(), value);
        return this;
    }

    public <T> ThingTemplateInfo addConfig(ConfigKeyValue<T> keyValue) {
        this.addConfig(keyValue.getKey(), keyValue.getValue());
        return this;
    }

    ThingTemplateInfo(String id, String name, String metadata, Long version, Map<String, Object> configuration) {
        this.id = id;
        this.name = name;
        this.metadata = metadata;
        this.version = version;
        this.configuration = configuration;
    }

    public static ThingTemplateInfoBuilder builder() {
        return new ThingTemplateInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Long getVersion() {
        return this.version;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public static class ThingTemplateInfoBuilder {
        private String id;
        private String name;
        private String metadata;
        private Long version;
        private Map<String, Object> configuration;

        ThingTemplateInfoBuilder() {
        }

        public ThingTemplateInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ThingTemplateInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThingTemplateInfoBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThingTemplateInfoBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public ThingTemplateInfoBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public ThingTemplateInfo build() {
            return new ThingTemplateInfo(this.id, this.name, this.metadata, this.version, this.configuration);
        }

        public String toString() {
            return "ThingTemplateInfo.ThingTemplateInfoBuilder(id=" + this.id + ", name=" + this.name + ", metadata=" + this.metadata + ", version=" + this.version + ", configuration=" + this.configuration + ")";
        }
    }
}

