/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.unit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Nullable;
import org.jetlinks.core.metadata.unit.ValueUnit;

public class JsonValueUnit
implements ValueUnit {
    private final String symbol;
    private final String name;

    @Nullable
    public static JsonValueUnit of(String jsonStr) {
        JSONObject json = JSON.parseObject(jsonStr);
        String symbol = json.getString("symbol");
        if (null == symbol) {
            return null;
        }
        return new JsonValueUnit(symbol, (String)json.getOrDefault((Object)"name", symbol));
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Object format(Object value) {
        if (value == null) {
            return null;
        }
        return value + "" + this.symbol;
    }

    @Override
    public String getId() {
        return "custom_" + this.symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.symbol;
    }

    public JsonValueUnit(String symbol, String name) {
        this.symbol = symbol;
        this.name = name;
    }
}

