/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.TextMessageParser;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpRequestMessage;
import org.jetlinks.core.message.codec.http.HttpUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class SimpleHttpRequestMessage
implements HttpRequestMessage {
    private ByteBuf payload;
    private String path;
    private String url;
    private HttpMethod method;
    private List<Header> headers;
    private Map<String, String> queryParameters;
    private MediaType contentType;

    public static SimpleHttpRequestMessage of(String httpString) {
        SimpleHttpRequestMessage request = new SimpleHttpRequestMessage();
        HttpHeaders httpHeaders = new HttpHeaders();
        TextMessageParser.of(start -> {
            String[] firstLine = start.split("[ ]");
            String method2 = firstLine[0];
            String url = firstLine[1];
            if (url.contains("?")) {
                String parameters = url.substring(url.indexOf("?") + 1);
                url = url.substring(0, url.indexOf("?"));
                request.setQueryParameters(Stream.of(parameters.split("[&]")).map(str -> str.split("[=]", 2)).filter(arr -> ((String[])arr).length > 1).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1], (a, b) -> String.join((CharSequence)",", a, b))));
            }
            request.setMethod(HttpMethod.resolve(method2));
            request.setPath(HttpUtils.getUrlPath(url));
            request.setUrl(url);
        }, httpHeaders::add, body2 -> {
            request.setPayload(Unpooled.wrappedBuffer(body2.getBody()));
            if (httpHeaders.getContentType() == null) {
                if (body2.getType() == MessagePayloadType.JSON) {
                    httpHeaders.setContentType(MediaType.APPLICATION_JSON);
                } else if (body2.getType() == MessagePayloadType.STRING) {
                    httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                }
            }
            request.setContentType(httpHeaders.getContentType());
        }, () -> {
            if (request.getContentType() == null) {
                request.setContentType(httpHeaders.getContentType());
            }
            request.setPayload(Unpooled.EMPTY_BUFFER);
        }).parse(httpString);
        request.setHeaders(httpHeaders.entrySet().stream().map(e -> new Header((String)e.getKey(), ((List)e.getValue()).toArray(new String[0]))).collect(Collectors.toList()));
        return request;
    }

    public static SimpleHttpRequestMessageBuilder builder() {
        return new SimpleHttpRequestMessageBuilder();
    }

    @Override
    public ByteBuf getPayload() {
        return this.payload;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public List<Header> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public void setPath(String path2) {
        this.path = path2;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(HttpMethod method2) {
        this.method = method2;
    }

    public void setHeaders(List<Header> headers2) {
        this.headers = headers2;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setContentType(MediaType contentType2) {
        this.contentType = contentType2;
    }

    public SimpleHttpRequestMessage(ByteBuf payload, String path2, String url, HttpMethod method2, List<Header> headers2, Map<String, String> queryParameters, MediaType contentType2) {
        this.payload = payload;
        this.path = path2;
        this.url = url;
        this.method = method2;
        this.headers = headers2;
        this.queryParameters = queryParameters;
        this.contentType = contentType2;
    }

    public SimpleHttpRequestMessage() {
    }

    public static class SimpleHttpRequestMessageBuilder {
        private ByteBuf payload;
        private String path;
        private String url;
        private HttpMethod method;
        private List<Header> headers;
        private Map<String, String> queryParameters;
        private MediaType contentType;

        SimpleHttpRequestMessageBuilder() {
        }

        public SimpleHttpRequestMessageBuilder payload(ByteBuf payload) {
            this.payload = payload;
            return this;
        }

        public SimpleHttpRequestMessageBuilder path(String path2) {
            this.path = path2;
            return this;
        }

        public SimpleHttpRequestMessageBuilder url(String url) {
            this.url = url;
            return this;
        }

        public SimpleHttpRequestMessageBuilder method(HttpMethod method2) {
            this.method = method2;
            return this;
        }

        public SimpleHttpRequestMessageBuilder headers(List<Header> headers2) {
            this.headers = headers2;
            return this;
        }

        public SimpleHttpRequestMessageBuilder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public SimpleHttpRequestMessageBuilder contentType(MediaType contentType2) {
            this.contentType = contentType2;
            return this;
        }

        public SimpleHttpRequestMessage build() {
            return new SimpleHttpRequestMessage(this.payload, this.path, this.url, this.method, this.headers, this.queryParameters, this.contentType);
        }

        public String toString() {
            return "SimpleHttpRequestMessage.SimpleHttpRequestMessageBuilder(payload=" + this.payload + ", path=" + this.path + ", url=" + this.url + ", method=" + (Object)((Object)this.method) + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", contentType=" + this.contentType + ")";
        }
    }
}

