/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import com.alibaba.fastjson.JSONObject;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.message.BroadcastMessage;
import org.jetlinks.core.message.Message;

public class DefaultBroadcastMessage
extends GenericHeaderSupport<DefaultBroadcastMessage>
implements BroadcastMessage {
    private static final long serialVersionUID = -6849794470754667710L;
    private String messageId;
    private long timestamp = System.currentTimeMillis();
    private String address;
    private Message message;

    @Override
    public BroadcastMessage message(Message message) {
        this.message = message;
        return this;
    }

    @Override
    public BroadcastMessage address(String address) {
        this.address = address;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = FastBeanCopier.copy(this, JSONObject::new, new String[0]);
        json.put("messageType", (Object)this.getMessageType().name());
        return json;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONObject headers2;
        FastBeanCopier.copy(jsonObject, this, "headers");
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        if (null != (headers2 = jsonObject.getJSONObject("headers"))) {
            headers2.forEach(this::addHeader);
        }
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setMessage(Message message) {
        this.message = message;
    }
}

