/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.defaults.ExpandsConfigMetadataSupplier;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadataType;
import reactor.core.publisher.Flux;

public class StaticExpandsConfigMetadataSupplier
implements ExpandsConfigMetadataSupplier {
    private final Map<String, List<ConfigMetadata>> metadata = new ConcurrentHashMap<String, List<ConfigMetadata>>();

    private List<ConfigMetadata> getOrCreateConfigs(String id) {
        return this.metadata.computeIfAbsent(id, ignore -> new ArrayList());
    }

    public StaticExpandsConfigMetadataSupplier addConfigMetadata(ConfigMetadata configMetadata) {
        this.getOrCreateConfigs("any:any").add(configMetadata);
        return this;
    }

    public StaticExpandsConfigMetadataSupplier addConfigMetadata(String typeId, ConfigMetadata configMetadata) {
        this.getOrCreateConfigs(String.join((CharSequence)":", "any", typeId)).add(configMetadata);
        return this;
    }

    public StaticExpandsConfigMetadataSupplier addConfigMetadata(DeviceMetadataType metadataType, ConfigMetadata configMetadata) {
        return this.addConfigMetadata(metadataType, "any", configMetadata);
    }

    public StaticExpandsConfigMetadataSupplier addConfigMetadata(DeviceMetadataType metadataType, String typeId, ConfigMetadata configMetadata) {
        this.getOrCreateConfigs(String.join((CharSequence)":", metadataType.name(), typeId)).add(configMetadata);
        return this;
    }

    @Override
    public Flux<ConfigMetadata> getConfigMetadata(DeviceMetadataType metadataType, String metadataId, String dataTypeId) {
        return Flux.merge(Flux.fromIterable(this.metadata.getOrDefault("any:any", Collections.emptyList())), Flux.fromIterable(this.metadata.getOrDefault(String.join((CharSequence)":", "any", dataTypeId), Collections.emptyList())), Flux.fromIterable(this.metadata.getOrDefault(String.join((CharSequence)":", metadataType.name(), "any"), Collections.emptyList())), Flux.fromIterable(this.metadata.getOrDefault(String.join((CharSequence)":", metadataType.name(), dataTypeId), Collections.emptyList())));
    }
}

