/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.utils.BytesUtils;

public class SubscriptionCodec
implements Codec<Subscription> {
    public static final SubscriptionCodec INSTANCE = new SubscriptionCodec();

    @Override
    public Class<Subscription> forType() {
        return Subscription.class;
    }

    @Override
    @Nullable
    public Subscription decode(@Nonnull Payload payload) {
        ByteBuf body2 = payload.getBody();
        byte[] subscriberLenArr = new byte[4];
        body2.getBytes(0, subscriberLenArr);
        int subscriberLen = BytesUtils.beToInt(subscriberLenArr);
        byte[] subscriber = new byte[subscriberLen];
        body2.getBytes(4, subscriber);
        String subscriberStr = new String(subscriber);
        byte[] featureBytes = new byte[8];
        body2.getBytes(4 + subscriberLen, featureBytes);
        Subscription.Feature[] features = EnumDict.getByMask(Subscription.Feature.class, BytesUtils.beToLong(featureBytes)).toArray(new Subscription.Feature[0]);
        int headerLen = 12 + subscriberLen;
        body2.resetReaderIndex();
        return Subscription.of(subscriberStr, body2.slice(headerLen, body2.readableBytes() - headerLen).toString(StandardCharsets.UTF_8).split("[\t]"), features);
    }

    @Override
    public Payload encode(Subscription body2) {
        byte[] subscriber = body2.getSubscriber().getBytes();
        byte[] subscriberLen = BytesUtils.intToBe(subscriber.length);
        long features = EnumDict.toMask((EnumDict[])body2.getFeatures());
        byte[] featureBytes = BytesUtils.longToBe(features);
        byte[] topics = String.join((CharSequence)"\t", body2.getTopics()).getBytes();
        return Payload.of(Unpooled.buffer(subscriberLen.length + subscriber.length + featureBytes.length + topics.length).writeBytes(subscriberLen).writeBytes(subscriber).writeBytes(featureBytes).writeBytes(topics));
    }
}

