/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;

public class JsonArrayCodec<T, R>
implements Codec<R> {
    private final Class<T> type;
    private final Class<R> resultType;
    private final Function<List<T>, R> mapper;

    private JsonArrayCodec(Class<T> type, Class<R> resultType, Function<List<T>, R> mapper) {
        this.type = type;
        this.resultType = resultType;
        this.mapper = mapper;
    }

    public static <T> JsonArrayCodec<T, List<T>> of(Class<T> type) {
        return JsonArrayCodec.of(type, List.class, Function.identity());
    }

    public static <T, R> JsonArrayCodec<T, R> of(Class<T> type, Class<R> resultType, Function<List<T>, R> function) {
        return new JsonArrayCodec<T, R>(type, resultType, function);
    }

    @Override
    public Class<R> forType() {
        return this.resultType;
    }

    @Override
    public R decode(@Nonnull Payload payload) {
        return this.mapper.apply(JSON.parseArray(payload.bodyToString(false), this.type));
    }

    @Override
    public Payload encode(R body2) {
        return Payload.of(JSON.toJSONBytes(body2, new SerializerFeature[0]));
    }
}

