/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.utils.BytesUtils;

public class IntegerCodec
implements Codec<Integer> {
    public static IntegerCodec INSTANCE = new IntegerCodec();

    private IntegerCodec() {
    }

    @Override
    public Class<Integer> forType() {
        return Integer.class;
    }

    @Override
    public Integer decode(@Nonnull Payload payload) {
        return BytesUtils.beToInt(payload.getBytes(false));
    }

    @Override
    public Payload encode(Integer body2) {
        return Payload.of(BytesUtils.intToBe(body2));
    }
}

