/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.core.ByteBufPayload;
import org.jetlinks.core.NativePayload;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.codec.Encoder;

public interface Payload
extends ReferenceCounted {
    public static final Payload voidPayload = Payload.of(Unpooled.EMPTY_BUFFER);

    @Nonnull
    @Deprecated
    public ByteBuf getBody();

    @Deprecated
    default public Payload slice() {
        return Payload.of(this.getBody().slice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    default public <T> T decode(Decoder<T> decoder, boolean release) {
        try {
            T t = decoder.decode(this);
            return t;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease(this);
            }
        }
    }

    @Deprecated
    default public <T> T decode(Decoder<T> decoder) {
        return this.decode(decoder, true);
    }

    @Deprecated
    default public <T> T decode(Class<T> decoder) {
        return this.decode(decoder, true);
    }

    @Deprecated
    default public <T> T decode(Class<T> decoder, boolean release) {
        return this.decode(Codecs.lookup(decoder), release);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Object decode(boolean release) {
        byte[] payload = this.getBytes(false);
        if (payload[0] == 123 && payload[payload.length - 1] == 125 || payload[0] == 91 && payload[payload.length - 1] == 93) {
            try {
                Object object = JSON.parse(new String(payload));
                return object;
            }
            finally {
                if (release) {
                    ReferenceCountUtil.safeRelease(this);
                }
            }
        }
        return this.decode(Object.class, release);
    }

    default public Object decode() {
        return this.decode(true);
    }

    @Deprecated
    default public <T> T convert(Function<ByteBuf, T> mapper) {
        return this.convert(mapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    default public <T> T convert(Function<ByteBuf, T> mapper, boolean release) {
        ByteBuf body2 = this.getBody();
        try {
            T t = mapper.apply(body2);
            return t;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease(this);
            }
        }
    }

    @Override
    @Deprecated
    default public Payload retain() {
        return this.retain(1);
    }

    @Override
    @Deprecated
    default public Payload retain(int inc) {
        this.getBody().retain(inc);
        return this;
    }

    @Override
    @Deprecated
    default public boolean release(int dec) {
        if (this.refCnt() >= dec) {
            return ReferenceCountUtil.release(this.getBody(), dec);
        }
        return true;
    }

    @Override
    @Deprecated
    default public boolean release() {
        return this.release(1);
    }

    @Deprecated
    default public byte[] getBytes() {
        return this.getBytes(true);
    }

    @Deprecated
    default public byte[] getBytes(boolean release) {
        return this.convert(ByteBufUtil::getBytes, release);
    }

    @Deprecated
    default public byte[] getBytes(int offset, int length, boolean release) {
        return this.convert(byteBuf -> ByteBufUtil.getBytes(byteBuf, offset, length), release);
    }

    default public String bodyToString() {
        return this.bodyToString(true);
    }

    default public String bodyToString(boolean release) {
        try {
            String string = this.getBody().toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease(this);
            }
        }
    }

    default public JSONObject bodyToJson(boolean release) {
        return this.decode(JSONObject.class, release);
    }

    default public JSONObject bodyToJson() {
        return this.bodyToJson(true);
    }

    default public JSONArray bodyToJsonArray() {
        return this.bodyToJsonArray(true);
    }

    default public JSONArray bodyToJsonArray(boolean release) {
        return this.decode(JSONArray.class);
    }

    @Override
    @Deprecated
    default public int refCnt() {
        return this.getBody().refCnt();
    }

    @Override
    @Deprecated
    default public Payload touch() {
        this.getBody().touch();
        return this;
    }

    @Override
    @Deprecated
    default public Payload touch(Object o) {
        this.getBody().touch(o);
        return this;
    }

    public static Payload of(ByteBuf body2) {
        return ByteBufPayload.of(body2);
    }

    public static Payload of(byte[] body2) {
        return Payload.of(Unpooled.wrappedBuffer(body2));
    }

    public static Payload of(String body2) {
        return Payload.of(body2.getBytes());
    }

    public static <T> Payload of(T body2, Encoder<T> encoder) {
        if (body2 instanceof Payload) {
            return encoder.encode(body2);
        }
        return NativePayload.of(body2, encoder);
    }
}

