/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.bean.DefaultToStringOperator;
import org.hswebframework.web.bean.ToStringOperator;
import org.springframework.util.ClassUtils;

public class ToString {
    public static long DEFAULT_FEATURE = Feature.createFeatures(Feature.coverIgnoreProperty, Feature.nullPropertyToEmpty);
    public static final Map<Class, ToStringOperator> cache = new ConcurrentHashMap<Class, ToStringOperator>();

    public static <T> ToStringOperator<T> getOperator(Class<T> type) {
        return cache.computeIfAbsent(type, DefaultToStringOperator::new);
    }

    public static <T> String toString(T target) {
        return ToString.getOperator(ClassUtils.getUserClass(target)).toString(target, new String[0]);
    }

    public static <T> String toString(T target, String ... ignoreProperty) {
        return ToString.getOperator(ClassUtils.getUserClass(target)).toString(target, ignoreProperty);
    }

    public static enum Feature {
        empty,
        ignoreNullProperty,
        nullPropertyToEmpty,
        coverIgnoreProperty,
        disableNestProperty,
        jsonFormat,
        writeClassname;


        public long getMask() {
            return 1L << this.ordinal();
        }

        public static boolean hasFeature(long features, Feature feature) {
            long mast = feature.getMask();
            return (features & mast) == mast;
        }

        public static long removeFeatures(long oldFeature, Feature ... features) {
            if (features == null) {
                return 0L;
            }
            long value = oldFeature;
            for (Feature feature : features) {
                value &= feature.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return value;
        }

        public static long createFeatures(Feature ... features) {
            if (features == null) {
                return 0L;
            }
            long value = 0L;
            for (Feature feature : features) {
                value |= feature.getMask();
            }
            return value;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Features {
        public Feature[] value() default {};
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Ignore {
        public String[] value() default {};

        public boolean cover() default true;
    }
}

