/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hswebframework.utils.DateTimeUtils;
import org.hswebframework.utils.StringUtils;

public class ClassUtils {
    public static final Set<Class> basicClass = new HashSet<Class>();

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation) {
        T ann = clazz.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ClassUtils.getAnnotation(clazz.getSuperclass(), annotation);
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Method method2, Class<T> annotation) {
        T ann = method2.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        Class<?> clazz = method2.getDeclaringClass();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            try {
                Method suMethod = superClass.getMethod(method2.getName(), method2.getParameterTypes());
                return ClassUtils.getAnnotation(suMethod, annotation);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }

    public static Class<?> getGenericTypeByType(ParameterizedType genType, int index) {
        Type[] params = genType.getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return null;
        }
        Type res = params[index];
        if (res instanceof Class) {
            return (Class)res;
        }
        if (res instanceof ParameterizedType) {
            return (Class)((ParameterizedType)res).getRawType();
        }
        return null;
    }

    public static Class<?> getGenericType(Class clazz, int index) {
        ArrayList<Type> arrys = new ArrayList<Type>();
        arrys.add(clazz.getGenericSuperclass());
        arrys.addAll(Arrays.asList(clazz.getGenericInterfaces()));
        return arrys.stream().filter(Objects::nonNull).map(type -> {
            if (clazz != Object.class && !(type instanceof ParameterizedType)) {
                return ClassUtils.getGenericType(clazz.getSuperclass(), index);
            }
            return ClassUtils.getGenericTypeByType((ParameterizedType)type, index);
        }).filter(Objects::nonNull).filter(res -> res != Object.class).findFirst().orElse(Object.class);
    }

    public static Class<?> getGenericType(Class clazz) {
        return ClassUtils.getGenericType(clazz, 0);
    }

    public static boolean instanceOf(Class clazz, Class target) {
        if (clazz == null) {
            return false;
        }
        if (clazz == target) {
            return true;
        }
        if (target.isInterface()) {
            for (Class<?> aClass : clazz.getInterfaces()) {
                if (aClass != target) continue;
                return true;
            }
        }
        if (clazz.getSuperclass() == target) {
            return true;
        }
        if (clazz.isInterface()) {
            for (Class<?> aClass : clazz.getInterfaces()) {
                if (!ClassUtils.instanceOf(aClass, target)) continue;
                return true;
            }
        }
        return ClassUtils.instanceOf(clazz.getSuperclass(), target);
    }

    public static final <T> T cast(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        Object newVal = null;
        if (ClassUtils.instanceOf(value.getClass(), type)) {
            newVal = value;
        } else if (type == Integer.class || type == Integer.TYPE) {
            newVal = StringUtils.toInt(value);
        } else if (type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            newVal = StringUtils.toDouble(value);
        } else if (type == Long.class || type == Long.TYPE) {
            newVal = StringUtils.toLong(value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            newVal = StringUtils.isTrue(value);
        } else if (type == Date.class) {
            newVal = DateTimeUtils.formatUnknownString2Date(value.toString());
        } else if (type == String.class) {
            newVal = value instanceof Date ? DateTimeUtils.format((Date)value, "yyyy-MM-dd HH:mm:ss") : String.valueOf(value);
        }
        return (T)newVal;
    }

    public static boolean isBasicClass(Class clazz) {
        return basicClass.contains(clazz);
    }

    static {
        basicClass.add(Integer.TYPE);
        basicClass.add(Double.TYPE);
        basicClass.add(Float.TYPE);
        basicClass.add(Byte.TYPE);
        basicClass.add(Short.TYPE);
        basicClass.add(Character.TYPE);
        basicClass.add(String.class);
    }
}

