/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.lang.reflect.Method;
import java.security.PrivilegedAction;

public final class GetDeclaredMethod
implements PrivilegedAction<Method> {
    private final Class<?> clazz;
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final boolean makeAccessible;

    public static GetDeclaredMethod action(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return new GetDeclaredMethod(clazz, methodName, false, parameterTypes);
    }

    public static GetDeclaredMethod andMakeAccessible(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return new GetDeclaredMethod(clazz, methodName, true, parameterTypes);
    }

    private GetDeclaredMethod(Class<?> clazz, String methodName, boolean makeAccessible, Class<?> ... parameterTypes) {
        this.clazz = clazz;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.makeAccessible = makeAccessible;
    }

    @Override
    public Method run() {
        try {
            Method method2 = this.clazz.getDeclaredMethod(this.methodName, this.parameterTypes);
            if (this.makeAccessible) {
                method2.setAccessible(true);
            }
            return method2;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

