/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.util.Arrays;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Var;

public class ExposedState {
    public static final boolean[] NO_ERRONEOUS_VARS = new boolean[0];
    public Var[] vars;
    private boolean[] erroneousVars;
    private Expr aspectInstance;
    private UnresolvedType[] expectedVarTypes;
    private ResolvedType concreteAspect;

    public ExposedState(int size) {
        if (size == 0) {
            this.vars = Var.NONE;
            this.erroneousVars = NO_ERRONEOUS_VARS;
        } else {
            this.vars = new Var[size];
            this.erroneousVars = new boolean[size];
        }
    }

    public ExposedState(Member signature) {
        this(signature.getParameterTypes().length);
        this.expectedVarTypes = new UnresolvedType[signature.getParameterTypes().length];
        if (this.expectedVarTypes.length > 0) {
            for (int i2 = 0; i2 < signature.getParameterTypes().length; ++i2) {
                this.expectedVarTypes[i2] = signature.getParameterTypes()[i2];
            }
        }
    }

    public boolean isFullySetUp() {
        for (Var var : this.vars) {
            if (var != null) continue;
            return false;
        }
        return true;
    }

    public void set(int i2, Var var) {
        ResolvedType expected;
        if (!(this.expectedVarTypes == null || (expected = this.expectedVarTypes[i2].resolve(var.getType().getWorld())).equals(ResolvedType.OBJECT) || expected.isAssignableFrom(var.getType()) || var.getType().isCoerceableFrom(expected))) {
            return;
        }
        this.vars[i2] = var;
    }

    public Var get(int i2) {
        return this.vars[i2];
    }

    public int size() {
        return this.vars.length;
    }

    public Expr getAspectInstance() {
        return this.aspectInstance;
    }

    public void setAspectInstance(Expr aspectInstance) {
        this.aspectInstance = aspectInstance;
    }

    public String toString() {
        return "ExposedState(#Vars=" + this.vars.length + ",Vars=" + Arrays.asList(this.vars) + ",AspectInstance=" + this.aspectInstance + ")";
    }

    public void setErroneousVar(int formalIndex) {
        this.erroneousVars[formalIndex] = true;
    }

    public boolean isErroneousVar(int formalIndex) {
        return this.erroneousVars[formalIndex];
    }

    public void setConcreteAspect(ResolvedType concreteAspect) {
        this.concreteAspect = concreteAspect;
    }

    public ResolvedType getConcreteAspect() {
        return this.concreteAspect;
    }
}

