/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class ExecuteDeParser
extends AbstractDeParser<Execute> {
    private ExpressionVisitor expressionVisitor;

    public ExecuteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Execute execute) {
        this.buffer.append(execute.getExecType().name()).append(" ").append(execute.getName());
        if (execute.isParenthesis()) {
            this.buffer.append(" (");
        } else if (execute.getExprList() != null) {
            this.buffer.append(" ");
        }
        if (execute.getExprList() != null) {
            List<Expression> expressions = execute.getExprList().getExpressions();
            for (int i2 = 0; i2 < expressions.size(); ++i2) {
                if (i2 > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(i2).accept(this.expressionVisitor);
            }
        }
        if (execute.isParenthesis()) {
            this.buffer.append(")");
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

