/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;

public class MergeUpdate {
    private List<Column> columns = null;
    private List<Expression> values = null;
    private Expression whereCondition;
    private Expression deleteWhereCondition;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> values) {
        this.values = values;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    public Expression getDeleteWhereCondition() {
        return this.deleteWhereCondition;
    }

    public void setDeleteWhereCondition(Expression deleteWhereCondition) {
        this.deleteWhereCondition = deleteWhereCondition;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(" WHEN MATCHED THEN UPDATE SET ");
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            if (i2 != 0) {
                b.append(", ");
            }
            b.append(this.columns.get(i2).toString()).append(" = ").append(this.values.get(i2).toString());
        }
        if (this.whereCondition != null) {
            b.append(" WHERE ").append(this.whereCondition.toString());
        }
        if (this.deleteWhereCondition != null) {
            b.append(" DELETE WHERE ").append(this.deleteWhereCondition.toString());
        }
        return b.toString();
    }

    public MergeUpdate withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public MergeUpdate withValues(List<Expression> values) {
        this.setValues(values);
        return this;
    }

    public MergeUpdate withWhereCondition(Expression whereCondition) {
        this.setWhereCondition(whereCondition);
        return this;
    }

    public MergeUpdate withDeleteWhereCondition(Expression deleteWhereCondition) {
        this.setDeleteWhereCondition(deleteWhereCondition);
        return this;
    }

    public MergeUpdate addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public MergeUpdate addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public MergeUpdate addValues(Expression ... values) {
        List collection = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        Collections.addAll(collection, values);
        return this.withValues(collection);
    }

    public MergeUpdate addValues(Collection<? extends Expression> values) {
        List collection = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        collection.addAll(values);
        return this.withValues(collection);
    }

    public <E extends Expression> E getWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhereCondition()));
    }

    public <E extends Expression> E getDeleteWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getDeleteWhereCondition()));
    }
}

