/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;

public class MessageProducerImpl<T>
implements MessageProducer<T> {
    private final Vertx vertx;
    private final EventBusImpl bus;
    private final boolean send;
    private final String address;
    private DeliveryOptions options;

    public MessageProducerImpl(Vertx vertx, String address, boolean send, DeliveryOptions options) {
        this.vertx = vertx;
        this.bus = (EventBusImpl)vertx.eventBus();
        this.address = address;
        this.send = send;
        this.options = options;
    }

    @Override
    public synchronized MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Future<Void> write(T body2) {
        PromiseInternal<Void> promise = ((VertxInternal)this.vertx).getOrCreateContext().promise();
        this.write(body2, (Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void write(T body2, Handler<AsyncResult<Void>> handler) {
        PromiseInternal promise = null;
        if (handler != null) {
            promise = ((VertxInternal)this.vertx).getOrCreateContext().promise(handler);
        }
        this.write(body2, promise);
    }

    private void write(T data, Promise<Void> handler) {
        MessageImpl msg = this.bus.createMessage(this.send, this.address, this.options.getHeaders(), data, this.options.getCodecName());
        this.bus.sendOrPubInternal(msg, this.options, null, handler);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Future<Void> close() {
        return ((ContextInternal)this.vertx.getOrCreateContext()).succeededFuture();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.close();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }
}

