/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.trace.ArrayBasedTraceState;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class ArrayBasedTraceStateBuilder
implements TraceStateBuilder {
    private static final int MAX_VENDOR_ID_SIZE = 13;
    private static final ArrayBasedTraceState EMPTY = ArrayBasedTraceState.create(Collections.emptyList());
    private static final int MAX_ENTRIES = 32;
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_TENANT_ID_SIZE = 240;
    private final List<String> reversedEntries;
    int numEntries;

    static TraceState empty() {
        return EMPTY;
    }

    ArrayBasedTraceStateBuilder() {
        this.reversedEntries = new ArrayList<String>();
        this.numEntries = 0;
    }

    ArrayBasedTraceStateBuilder(ArrayBasedTraceState parent) {
        List<String> entries = parent.getEntries();
        int size = entries.size();
        this.reversedEntries = new ArrayList<String>(size);
        for (int i2 = size - 2; i2 >= 0; i2 -= 2) {
            this.reversedEntries.add(entries.get(i2));
            this.reversedEntries.add(entries.get(i2 + 1));
        }
        this.numEntries = size / 2;
    }

    @Override
    public TraceStateBuilder put(String key, String value) {
        if (!ArrayBasedTraceStateBuilder.isKeyValid(key) || !ArrayBasedTraceStateBuilder.isValueValid(value) || this.numEntries >= 32) {
            return this;
        }
        for (int i2 = 0; i2 < this.reversedEntries.size(); i2 += 2) {
            if (!this.reversedEntries.get(i2).equals(key)) continue;
            String currentValue = this.reversedEntries.get(i2 + 1);
            this.reversedEntries.set(i2 + 1, value);
            if (currentValue == null) {
                ++this.numEntries;
            }
            return this;
        }
        this.reversedEntries.add(key);
        this.reversedEntries.add(value);
        ++this.numEntries;
        return this;
    }

    @Override
    public TraceStateBuilder remove(String key) {
        if (key == null) {
            return this;
        }
        for (int i2 = 0; i2 < this.reversedEntries.size(); i2 += 2) {
            if (!this.reversedEntries.get(i2).equals(key)) continue;
            this.reversedEntries.set(i2 + 1, null);
            --this.numEntries;
            return this;
        }
        return this;
    }

    @Override
    public TraceState build() {
        if (this.numEntries == 0) {
            return ArrayBasedTraceStateBuilder.empty();
        }
        if (this.reversedEntries.size() == 2) {
            return ArrayBasedTraceState.create(new ArrayList<String>(this.reversedEntries));
        }
        String[] entries = new String[this.numEntries * 2];
        int pos = 0;
        for (int i2 = this.reversedEntries.size() - 2; i2 >= 0; i2 -= 2) {
            String key = this.reversedEntries.get(i2);
            String value = this.reversedEntries.get(i2 + 1);
            if (value == null) continue;
            entries[pos++] = key;
            entries[pos++] = value;
        }
        return ArrayBasedTraceState.create(Arrays.asList(entries));
    }

    private static boolean isKeyValid(@Nullable String key) {
        if (key == null) {
            return false;
        }
        if (key.length() > 256 || key.isEmpty() || ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(key.charAt(0))) {
            return false;
        }
        boolean isMultiTenantVendorKey = false;
        for (int i2 = 1; i2 < key.length(); ++i2) {
            char c = key.charAt(i2);
            if (ArrayBasedTraceStateBuilder.isNotLegalKeyCharacter(c)) {
                return false;
            }
            if (c != '@') continue;
            if (isMultiTenantVendorKey) {
                return false;
            }
            isMultiTenantVendorKey = true;
            if (i2 > 240) {
                return false;
            }
            int remainingKeyChars = key.length() - i2 - 1;
            if (remainingKeyChars <= 13 && remainingKeyChars != 0) continue;
            return false;
        }
        if (!isMultiTenantVendorKey) {
            return ArrayBasedTraceStateBuilder.isNotDigit(key.charAt(0));
        }
        return true;
    }

    private static boolean isNotLegalKeyCharacter(char c) {
        return ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(c) && c != '_' && c != '-' && c != '@' && c != '*' && c != '/';
    }

    private static boolean isNotLowercaseLetterOrDigit(char ch) {
        return (ch < 'a' || ch > 'z') && ArrayBasedTraceStateBuilder.isNotDigit(ch);
    }

    private static boolean isNotDigit(char ch) {
        return ch < '0' || ch > '9';
    }

    private static boolean isValueValid(@Nullable String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return false;
        }
        if (value.length() > 256 || value.charAt(value.length() - 1) == ' ') {
            return false;
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c != ',' && c != '=' && c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }
}

