/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.SignalType;

class TraceSubscriber<T>
extends BaseSubscriber<T>
implements Span {
    static final AttributeKey<Long> count = AttributeKey.longKey("count");
    static final AtomicLongFieldUpdater<TraceSubscriber> NEXT_COUNT = AtomicLongFieldUpdater.newUpdater(TraceSubscriber.class, "nextCount");
    private final CoreSubscriber<? super T> actual;
    private final Span span;
    private final BiConsumer<Span, T> onNext;
    private final BiConsumer<Span, Long> onComplete;
    private volatile long nextCount;
    private volatile boolean stateSet;
    private final reactor.util.context.Context context;

    public TraceSubscriber(CoreSubscriber<? super T> actual, Span span, BiConsumer<Span, T> onNext, BiConsumer<Span, Long> onComplete, Context ctx) {
        this.actual = actual;
        this.span = span;
        this.onNext = onNext;
        this.onComplete = onComplete;
        this.context = reactor.util.context.Context.of(actual.currentContext()).put(SpanContext.class, span.getSpanContext()).put(Context.class, span.storeInContext(ctx));
    }

    @Override
    protected void hookOnSubscribe(@Nonnull Subscription subscription) {
        this.actual.onSubscribe(this);
    }

    @Override
    protected void hookOnError(@Nonnull Throwable throwable) {
        this.span.setStatus(StatusCode.ERROR);
        this.span.recordException(throwable);
        try (Scope scope = this.span.makeCurrent();){
            this.actual.onError(throwable);
        }
    }

    @Override
    @Nonnull
    public reactor.util.context.Context currentContext() {
        return this.context;
    }

    @Override
    protected void hookFinally(@Nonnull SignalType type) {
        this.span.end();
    }

    @Override
    protected void hookOnCancel() {
        if (!this.stateSet) {
            this.span.setStatus(StatusCode.ERROR, "cancel");
        }
    }

    @Override
    protected void hookOnNext(@Nonnull T value) {
        if (null != this.onNext) {
            this.onNext.accept(this, (Span)value);
        }
        NEXT_COUNT.incrementAndGet(this);
        try (Scope scope = this.span.makeCurrent();){
            this.actual.onNext(value);
        }
    }

    @Override
    protected void hookOnComplete() {
        if (this.onComplete != null) {
            this.onComplete.accept(this, this.nextCount);
        }
        this.span.setAttribute(count, Long.valueOf(this.nextCount));
        if (!this.stateSet) {
            this.span.setStatus(StatusCode.OK);
        }
        try (Scope scope = this.span.makeCurrent();){
            this.actual.onComplete();
        }
    }

    public <R> Span setAttribute(@Nonnull AttributeKey<R> key, @Nonnull R value) {
        this.span.setAttribute(key, value);
        return this;
    }

    @Override
    public Span addEvent(@Nonnull String name, @Nonnull Attributes attributes) {
        this.span.addEvent(name, attributes);
        return this;
    }

    @Override
    public Span addEvent(@Nonnull String name, @Nonnull Attributes attributes, long timestamp, @Nonnull TimeUnit unit) {
        this.span.addEvent(name, attributes, timestamp, unit);
        return this;
    }

    @Override
    public Span setStatus(@Nonnull StatusCode statusCode, @Nonnull String description) {
        this.stateSet = true;
        this.span.setStatus(statusCode, description);
        return this;
    }

    @Override
    public Span recordException(@Nonnull Throwable exception, @Nonnull Attributes additionalAttributes) {
        this.span.recordException(exception, additionalAttributes);
        return this;
    }

    @Override
    public Span updateName(@Nonnull String name) {
        this.span.updateName(name);
        return this;
    }

    @Override
    public void end() {
    }

    @Override
    public void end(long timestamp, @Nonnull TimeUnit unit) {
    }

    @Override
    public SpanContext getSpanContext() {
        return this.span.getSpanContext();
    }

    @Override
    public boolean isRecording() {
        return this.span.isRecording();
    }
}

