/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.things.ThingId;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsDataManager;
import org.jetlinks.core.things.ThingsDataManagerSupport;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;

public class DefaultThingsDataManager
implements ThingsDataManager {
    private final Map<ThingId, ThingPropertyRef> localCache = DefaultThingsDataManager.newCache();
    private final List<ThingsDataManagerSupport> supports = new CopyOnWriteArrayList<ThingsDataManagerSupport>();
    private final ThingsRegistry registry;
    private static final Object NULL = new Object();

    static <K, V> Map<K, V> newCache() {
        return Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).removalListener((key, value, removalCause) -> {
            if (value instanceof Disposable) {
                ((Disposable)value).dispose();
            }
        }).build().asMap();
    }

    public void addSupport(ThingsDataManagerSupport support) {
        this.supports.add(support);
    }

    @Override
    public final Mono<ThingProperty> getLastProperty(String thingType, String thingId, String property, long baseTime) {
        return this.localCache.computeIfAbsent(ThingId.of(thingType, thingId), x$0 -> new ThingPropertyRef((ThingId)x$0)).getLastProperty(property, baseTime);
    }

    @Override
    public final Mono<ThingProperty> getFirstProperty(String thingType, String thingId, String property) {
        return this.localCache.computeIfAbsent(ThingId.of(thingType, thingId), x$0 -> new ThingPropertyRef((ThingId)x$0)).getFirstProperty(property);
    }

    @Override
    public Mono<Long> getLastPropertyTime(String thingType, String thingId, long baseTime) {
        return this.localCache.computeIfAbsent(ThingId.of(thingType, thingId), x$0 -> new ThingPropertyRef((ThingId)x$0)).getLastPropertyTime(baseTime);
    }

    @Override
    public Mono<Long> getFirstPropertyTime(String thingType, String thingId) {
        return Mono.empty();
    }

    public <T> T computeSupport(ThingType thingType, Function<ThingsDataManagerSupport, T> supportTFunction, Supplier<T> undefined) {
        for (ThingsDataManagerSupport support : this.supports) {
            if (!support.isSupported(thingType)) continue;
            return supportTFunction.apply(support);
        }
        return undefined.get();
    }

    public DefaultThingsDataManager(ThingsRegistry registry) {
        this.registry = registry;
    }

    class ThingPropertyRef
    implements Disposable {
        Disposable disposable;
        Map<String, PropertyRef> refs = new ConcurrentHashMap<String, PropertyRef>();
        ThingType thingType;
        String thingId;
        private long lastPropertyTime;
        private long propertyTime;

        public ThingPropertyRef(ThingId cacheKey) {
            this(ThingType.of(cacheKey.getType()), cacheKey.getId());
        }

        public ThingPropertyRef(ThingType thingType, String thingId) {
            this.thingId = thingId;
            this.thingType = thingType;
            this.disposable = DefaultThingsDataManager.this.computeSupport(thingType, support -> support.subscribeProperty(thingType, thingId).subscribe(this::upgrade), Disposables::disposed);
        }

        private void upgrade(ThingProperty property) {
            PropertyRef ref = this.refs.get(property.getProperty());
            if (null != ref) {
                ref.setValue(property.getValue(), property.getTimestamp(), property.getState());
            }
            this.updatePropertyTime(property.getTimestamp());
        }

        private long updatePropertyTime(long timestamp) {
            if (this.propertyTime <= timestamp) {
                this.lastPropertyTime = this.propertyTime;
                this.propertyTime = timestamp;
            }
            return this.propertyTime;
        }

        public Mono<ThingProperty> getFirstProperty(String property) {
            PropertyRef ref = this.refs.computeIfAbsent(property, ignore -> new PropertyRef(property));
            if (ref.first != null && ref.first.getValue() != null) {
                if (ref.first.getValue() == NULL) {
                    return Mono.empty();
                }
                return Mono.just(ref.first);
            }
            return DefaultThingsDataManager.this.computeSupport(this.thingType, support -> support.getFirstProperty(this.thingType, this.thingId, property), Mono::empty).map(prop -> ref.setFirst(prop.getValue(), prop.getTimestamp())).switchIfEmpty(Mono.fromRunnable(ref::setFirstNull));
        }

        public Mono<Long> getLastPropertyTime(long baseTime) {
            if (this.propertyTime == -1L) {
                return Mono.empty();
            }
            if (this.propertyTime > 0L && this.propertyTime < baseTime) {
                return Mono.just(this.propertyTime);
            }
            if (this.lastPropertyTime > 0L && this.lastPropertyTime < baseTime) {
                return Mono.just(this.lastPropertyTime);
            }
            return DefaultThingsDataManager.this.computeSupport(this.thingType, support -> support.getAnyLastProperty(this.thingType, this.thingId, baseTime), Mono::empty).map(val -> {
                if (this.propertyTime <= 0L) {
                    this.updatePropertyTime(val.getTimestamp());
                }
                return val.getTimestamp();
            }).switchIfEmpty(Mono.fromRunnable(() -> {
                if (this.propertyTime == 0L) {
                    this.propertyTime = -1L;
                }
            }));
        }

        public Mono<ThingProperty> getLastProperty(String key, long baseTime) {
            Function<Mono, Mono> resultHandler;
            PropertyRef ref = this.refs.computeIfAbsent(key, PropertyRef::new);
            Object val = ref.getValue();
            if (val == NULL) {
                return Mono.empty();
            }
            if (val != null) {
                if (ref.timestamp < baseTime) {
                    return Mono.just(ref.copy());
                }
                if (ref.pre != null && ref.pre.timestamp < baseTime && ref.pre.value != null && ref.pre.value != NULL) {
                    return Mono.just(ref.pre.copy());
                }
                resultHandler = prop -> prop.map(propertyValue -> new PropertyRef(key).setValue(propertyValue.getValue(), propertyValue.getTimestamp(), propertyValue.getState()));
            } else {
                resultHandler = prop -> prop.map(propertyValue -> ref.setValue(propertyValue.getValue(), propertyValue.getTimestamp(), propertyValue.getState())).switchIfEmpty(Mono.fromRunnable(ref::setNull));
            }
            return DefaultThingsDataManager.this.computeSupport(this.thingType, support -> support.getLastProperty(this.thingType, this.thingId, key, baseTime), Mono::empty).as(resultHandler);
        }

        @Override
        public void dispose() {
            this.disposable.dispose();
        }
    }

    static class PropertyRef
    implements ThingProperty {
        private final String property;
        private volatile Object value;
        private volatile String state;
        private volatile long timestamp;
        private transient PropertyRef pre;
        private transient PropertyRef first;

        public PropertyRef(String property) {
            this.property = property;
        }

        PropertyRef setValue(Object value, long ts, String state) {
            if (this.value == null || this.value == NULL || ts >= this.timestamp) {
                if (this.pre == null) {
                    this.pre = new PropertyRef(this.property);
                }
                this.pre.value = this.value;
                this.pre.timestamp = this.timestamp;
                this.pre.value = this.state;
                this.value = value;
                this.timestamp = ts;
                this.state = state;
            }
            return this;
        }

        void setNull() {
            if (this.value == null) {
                this.value = NULL;
            }
        }

        PropertyRef setFirst(Object value, long ts) {
            if (this.first == null) {
                this.first = new PropertyRef(this.property);
            }
            if (this.first.value == null || this.first.value == NULL || ts <= this.first.timestamp) {
                this.first.value = value;
                this.first.timestamp = ts;
            }
            return this.first;
        }

        PropertyRef setFirstNull() {
            if (this.first == null) {
                this.first = new PropertyRef(this.property);
                this.first.value = NULL;
            }
            return this.first;
        }

        ThingProperty copy() {
            return ThingProperty.of(this.property, this.value, this.timestamp);
        }

        @Override
        public String getProperty() {
            return this.property;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

