/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.simulator.core.network.NetworkType;
import org.jetlinks.simulator.core.network.NetworkUtils;
import reactor.core.Disposable;

public interface Connection
extends Disposable {
    public static final String ATTR_STATE = "state";
    public static final String ATTR_SENT = "sent";
    public static final String ATTR_RECEIVE = "received";
    public static final String ATTR_SENT_BYTES = "sent_bytes";
    public static final String ATTR_RECEIVE_BYTES = "received_bytes";

    public static String statusCountAttr(String status) {
        return "status_" + status;
    }

    default public Map<String, Integer> statusCount() {
        return Maps.transformValues(Maps.filterKeys(this.attributes(), k -> k.startsWith("status_")), v -> CastUtils.castNumber(v).intValue());
    }

    public String getId();

    public NetworkType getType();

    public boolean isAlive();

    public State state();

    public long getConnectTime();

    public Disposable onStateChange(BiConsumer<State, State> var1);

    public Optional<Object> attribute(String var1);

    public void attribute(String var1, Object var2);

    public void attributes(Map<String, Object> var1);

    default public void set(String key, Object value) {
        this.attribute(key, value);
    }

    default public Object get(String key) {
        return this.attribute(key).orElse(null);
    }

    public Map<String, Object> attributes();

    default public <T> T unwrap(Class<T> type) {
        return type.cast(this);
    }

    default public boolean isWrapFor(Class<?> type) {
        return type.isInstance(this);
    }

    default public ByteBuf newBuffer() {
        return Unpooled.buffer();
    }

    default public String toHex(Object data) {
        return ByteBufUtil.hexDump(NetworkUtils.castToByteBuf(data));
    }

    default public void reset() {
    }

    public static enum State {
        connecting,
        connected,
        closed,
        error;

    }
}

