/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.util.internal.ObjectPool;
import java.util.ArrayDeque;

public final class RecyclableDequeue<T>
extends ArrayDeque<T> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final ObjectPool<RecyclableDequeue<Object>> RECYCLER = ObjectPool.newPool(RecyclableDequeue::new);
    private final ObjectPool.Handle<RecyclableDequeue<T>> handle;

    public static <T> RecyclableDequeue<T> newInstance() {
        return RECYCLER.get();
    }

    private RecyclableDequeue(ObjectPool.Handle<RecyclableDequeue<T>> handle) {
        this(handle, 8);
    }

    private RecyclableDequeue(ObjectPool.Handle<RecyclableDequeue<T>> handle, int initialCapacity) {
        super(initialCapacity);
        this.handle = handle;
    }

    public boolean recycle() {
        this.clear();
        if (this.handle != null) {
            this.handle.recycle(this);
        }
        return true;
    }
}

