/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.jetlinks.simulator.core.Connection;
import reactor.core.Disposable;

public abstract class AbstractConnection
implements Connection {
    private volatile Connection.State state = Connection.State.connecting;
    private List<BiConsumer<Connection.State, Connection.State>> listener;
    private final long connectTime = System.currentTimeMillis();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    @Override
    public Optional<Object> attribute(String key) {
        return Optional.ofNullable(this.attributes.get(key));
    }

    public Object attr(String key) {
        return this.attribute(key).orElse(null);
    }

    @Override
    public void attribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void attributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    @Override
    public Map<String, Object> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public final Connection.State state() {
        return this.state;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    protected <T> T computeAttr(String key, T value, BiFunction<T, T, T> computer) {
        return (T)this.attributes.compute(key, (ignore, old) -> old == null ? value : computer.apply(value, old));
    }

    protected void incr(String key) {
        this.computeAttr(key, 1, Math::addExact);
    }

    protected void error(Throwable throwable) {
        this.incr(Connection.statusCountAttr("ERROR"));
    }

    protected void sent(int bytesLength) {
        this.computeAttr("sent", 1, Math::addExact);
        this.computeAttr("sent_bytes", bytesLength, Math::addExact);
    }

    protected void received(int bytesLength) {
        this.computeAttr("received", 1, Math::addExact);
        this.computeAttr("received_bytes", bytesLength, Math::addExact);
    }

    protected void changeState(Connection.State state) {
        this.attribute("state", state.name());
        Connection.State old = this.state;
        this.state = state;
        if (old != this.state && this.listener != null) {
            for (BiConsumer<Connection.State, Connection.State> consumer : this.listener) {
                consumer.accept(old, this.state);
            }
        }
    }

    @Override
    public final synchronized Disposable onStateChange(BiConsumer<Connection.State, Connection.State> listener) {
        if (this.listener == null) {
            this.listener = new ArrayList<BiConsumer<Connection.State, Connection.State>>();
        }
        this.listener.add(listener);
        return () -> {
            if (this.listener == null) {
                return;
            }
            this.listener.remove(listener);
        };
    }

    protected void doDisposed() {
    }

    @Override
    public final void dispose() {
        this.changeState(Connection.State.closed);
        this.doDisposed();
    }
}

