/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetlinks.core.message.codec.http.MultiPartParser;
import org.jetlinks.core.message.codec.http.Part;
import org.jetlinks.core.message.codec.http.SimpleMultiPart;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MultiPart {
    public static final List<MediaType> MIME_TYPES = Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED);

    public Optional<Part> getPart(String var1);

    public List<Part> getParts();

    public static MultiPart of(Part ... parts) {
        return MultiPart.of(Arrays.asList(parts));
    }

    public static MultiPart of(List<Part> parts) {
        return new SimpleMultiPart(parts);
    }

    public static Mono<MultiPart> parse(HttpHeaders headers2, Flux<ByteBuf> body2) {
        return MultiPartParser.parser(headers2, body2);
    }

    public static boolean isMultiPart(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        for (MediaType supportedMediaType : MIME_TYPES) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }
}

