/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.util.Map;
import javax.annotation.Nonnull;
import org.jetlinks.core.Embedded;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.route.Route;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.DeviceGatewayContext;
import org.springframework.core.Ordered;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ProtocolSupport
extends Disposable,
Ordered,
Comparable<ProtocolSupport> {
    @Nonnull
    public String getId();

    public String getName();

    public String getDescription();

    default public String getDocument(Transport transport) {
        return null;
    }

    public Flux<? extends Transport> getSupportedTransport();

    @Nonnull
    public Mono<? extends DeviceMessageCodec> getMessageCodec(Transport var1);

    default public Mono<DeviceMessageSenderInterceptor> getSenderInterceptor() {
        return Mono.just(DeviceMessageSenderInterceptor.DO_NOTING);
    }

    @Nonnull
    public DeviceMetadataCodec getMetadataCodec();

    default public Flux<DeviceMetadataCodec> getMetadataCodecs() {
        return Flux.just(this.getMetadataCodec());
    }

    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest var1, @Nonnull DeviceOperator var2);

    @Nonnull
    default public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceRegistry registry) {
        return Mono.error(new UnsupportedOperationException());
    }

    @Nonnull
    default public Mono<DeviceStateChecker> getStateChecker() {
        return Mono.empty();
    }

    default public Mono<ConfigMetadata> getConfigMetadata(Transport transport) {
        return Mono.empty();
    }

    default public Mono<ConfigMetadata> getInitConfigMetadata() {
        return Mono.empty();
    }

    default public void init(Map<String, Object> configuration) {
    }

    @Override
    default public void dispose() {
    }

    default public Mono<DeviceMetadata> getDefaultMetadata(Transport transport) {
        return Mono.empty();
    }

    default public Flux<ConfigMetadata> getMetadataExpandsConfig(Transport transport, DeviceMetadataType metadataType, String metadataId, String dataTypeId) {
        return Flux.empty();
    }

    default public Mono<Void> onDeviceRegister(DeviceOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onDeviceUnRegister(DeviceOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onProductRegister(DeviceProductOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onProductUnRegister(DeviceProductOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onProductMetadataChanged(DeviceProductOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onDeviceMetadataChanged(DeviceOperator operator) {
        return Mono.empty();
    }

    default public Mono<Void> onClientConnect(Transport transport, ClientConnection connection, DeviceGatewayContext context) {
        return Mono.empty();
    }

    default public Mono<Void> onChildBind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return Mono.empty();
    }

    default public Mono<Void> onChildUnbind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return Mono.empty();
    }

    default public Flux<Feature> getFeatures(Transport transport) {
        return Flux.empty();
    }

    default public Mono<DeviceInfo> doBeforeDeviceCreate(Transport transport, DeviceInfo deviceInfo) {
        return Mono.just(deviceInfo);
    }

    default public Flux<Route> getRoutes(Transport transport) {
        return Flux.empty();
    }

    @Override
    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    default public int compareTo(@Nonnull ProtocolSupport o) {
        return Integer.compare(this.getOrder(), o.getOrder());
    }

    default public boolean isEmbedded() {
        return this instanceof Embedded;
    }
}

