/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WebSocketMessage {
    private final Type type;
    private final DataBuffer payload;
    @Nullable
    private final Object nativeMessage;

    public WebSocketMessage(Type type, DataBuffer payload) {
        this(type, payload, null);
    }

    public WebSocketMessage(Type type, DataBuffer payload, @Nullable Object nativeMessage) {
        Assert.notNull((Object)type, "'type' must not be null");
        Assert.notNull((Object)payload, "'payload' must not be null");
        this.type = type;
        this.payload = payload;
        this.nativeMessage = nativeMessage;
    }

    public Type getType() {
        return this.type;
    }

    public DataBuffer getPayload() {
        return this.payload;
    }

    @Nullable
    public <T> T getNativeMessage() {
        return (T)this.nativeMessage;
    }

    public String getPayloadAsText() {
        return this.getPayloadAsText(StandardCharsets.UTF_8);
    }

    public String getPayloadAsText(Charset charset) {
        return this.payload.toString(charset);
    }

    public WebSocketMessage retain() {
        DataBufferUtils.retain(this.payload);
        return this;
    }

    public void release() {
        DataBufferUtils.release(this.payload);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebSocketMessage)) {
            return false;
        }
        WebSocketMessage otherMessage = (WebSocketMessage)other;
        return this.type.equals((Object)otherMessage.type) && ObjectUtils.nullSafeEquals(this.payload, otherMessage.payload);
    }

    public int hashCode() {
        return this.type.hashCode() * 29 + this.payload.hashCode();
    }

    public String toString() {
        return "WebSocket " + this.type.name() + " message (" + this.payload.readableByteCount() + " bytes)";
    }

    public static enum Type {
        TEXT,
        BINARY,
        PING,
        PONG;

    }
}

