/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HandlerFunctionAdapter
implements HandlerAdapter {
    private static final MethodParameter HANDLER_FUNCTION_RETURN_TYPE;

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerFunction;
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange2, Object handler) {
        HandlerFunction handlerFunction = (HandlerFunction)handler;
        ServerRequest request = (ServerRequest)exchange2.getRequiredAttribute(RouterFunctions.REQUEST_ATTRIBUTE);
        return handlerFunction.handle(request).map(response -> new HandlerResult(handlerFunction, response, HANDLER_FUNCTION_RETURN_TYPE));
    }

    static {
        try {
            Method method2 = HandlerFunction.class.getMethod("handle", ServerRequest.class);
            HANDLER_FUNCTION_RETURN_TYPE = new MethodParameter(method2, -1);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

