/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.aop.AfterAdvice;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.TypeUtils;

public class AspectJAfterReturningAdvice
extends AbstractAspectJAdvice
implements AfterReturningAdvice,
AfterAdvice,
Serializable {
    public AspectJAfterReturningAdvice(Method aspectJBeforeAdviceMethod, AspectJExpressionPointcut pointcut, AspectInstanceFactory aif) {
        super(aspectJBeforeAdviceMethod, pointcut, aif);
    }

    @Override
    public boolean isBeforeAdvice() {
        return false;
    }

    @Override
    public boolean isAfterAdvice() {
        return true;
    }

    @Override
    public void setReturningName(String name) {
        this.setReturningNameNoCheck(name);
    }

    @Override
    public void afterReturning(@Nullable Object returnValue, Method method2, Object[] args, @Nullable Object target) throws Throwable {
        if (this.shouldInvokeOnReturnValueOf(method2, returnValue)) {
            this.invokeAdviceMethod(this.getJoinPointMatch(), returnValue, null);
        }
    }

    private boolean shouldInvokeOnReturnValueOf(Method method2, @Nullable Object returnValue) {
        Class<?> type = this.getDiscoveredReturningType();
        Type genericType = this.getDiscoveredReturningGenericType();
        return this.matchesReturnValue(type, method2, returnValue) && (genericType == null || genericType == type || TypeUtils.isAssignable(genericType, method2.getGenericReturnType()));
    }

    private boolean matchesReturnValue(Class<?> type, Method method2, @Nullable Object returnValue) {
        if (returnValue != null) {
            return ClassUtils.isAssignableValue(type, returnValue);
        }
        if (Object.class == type && Void.TYPE == method2.getReturnType()) {
            return true;
        }
        return ClassUtils.isAssignable(type, method2.getReturnType());
    }
}

