/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things;

import java.util.Objects;
import java.util.StringJoiner;
import org.jetlinks.core.things.ThingTypes;
import org.jetlinks.core.things.TopicSupport;
import org.jetlinks.core.things.UndefinedThingType;

public interface ThingType
extends TopicSupport {
    public String getId();

    public String getName();

    default public boolean isEmbedded() {
        return this instanceof Enum;
    }

    default public boolean isSameType(ThingType thingType) {
        return this == thingType || Objects.equals(thingType.getId(), this.getId());
    }

    @Override
    default public String getTopicPrefix(String templateId, String thingId) {
        StringJoiner joiner = new StringJoiner("/", "/", "");
        joiner.add(this.getId()).add(templateId).add(thingId);
        return joiner.toString();
    }

    public static ThingType of(String id) {
        return ThingTypes.lookupOrElse(id, UndefinedThingType::of);
    }
}

