/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hswebframework.web.dict.Dict;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.util.Assert;

public class Subscription
implements Externalizable {
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Feature[] DEFAULT_FEATURES = Feature.values();
    private String subscriber;
    private String[] topics;
    private Feature[] features;
    private transient Runnable doOnSubscribe;
    private int priority = Integer.MAX_VALUE;

    public Subscription() {
    }

    public static Subscription of(String subscriber, String ... topic) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).build();
    }

    public static Subscription of(String subscriber, String[] topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public static Subscription of(String subscriber, String topic, Feature ... features) {
        return Subscription.builder().subscriberId(subscriber).topics(topic).features(features).build();
    }

    public Subscription copy(Feature ... newFeatures) {
        return new Subscription(this.subscriber, this.topics, newFeatures, null, this.priority);
    }

    public Subscription onSubscribe(Runnable sub) {
        this.doOnSubscribe = sub;
        return this;
    }

    public boolean hasFeature(Feature feature) {
        return feature.in(this.features);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.subscriber);
        out.writeInt(this.topics.length);
        for (String topic : this.topics) {
            out.writeUTF(topic);
        }
        out.writeLong(EnumDict.toMask((EnumDict[])this.features));
        out.writeInt(this.priority);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subscriber = in.readUTF();
        int len = in.readInt();
        this.topics = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this.topics[i2] = in.readUTF();
        }
        this.features = EnumDict.getByMask(Feature.class, in.readLong()).toArray(new Feature[0]);
        this.priority = in.readInt();
    }

    public String toString() {
        return "Subscription{subscriber='" + this.subscriber + '\'' + ", topics=" + Arrays.toString(this.topics) + ", features=" + Arrays.toString(this.features) + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Subscription(String subscriber, String[] topics, Feature[] features, Runnable doOnSubscribe, int priority) {
        this.subscriber = subscriber;
        this.topics = topics;
        this.features = features;
        this.doOnSubscribe = doOnSubscribe;
        this.priority = priority;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public Runnable getDoOnSubscribe() {
        return this.doOnSubscribe;
    }

    public int getPriority() {
        return this.priority;
    }

    public static class Builder {
        private String subscriber;
        private final Set<String> topics = new HashSet<String>();
        private final Set<Feature> features = new HashSet<Feature>();
        private Runnable doOnSubscribe;
        private int priority;

        public Builder randomSubscriberId() {
            return this.subscriberId(UUID.randomUUID().toString());
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder subscriberId(String id) {
            this.subscriber = id;
            return this;
        }

        public Builder topics(String ... topics) {
            return this.topics(Arrays.asList(topics));
        }

        public Builder topics(Collection<String> topics) {
            this.topics.addAll(topics.stream().flatMap(topic -> TopicUtils.expand(topic).stream()).collect(Collectors.toSet()));
            return this;
        }

        public Builder features(Feature ... features) {
            this.features.addAll(Arrays.asList(features));
            return this;
        }

        public Builder doOnSubscribe(Runnable runnable) {
            this.doOnSubscribe = runnable;
            return this;
        }

        public Builder justLocal() {
            this.features.clear();
            return this.features(Feature.local);
        }

        public Builder justBroker() {
            this.features.clear();
            return this.features(Feature.broker);
        }

        public Builder local() {
            return this.features(Feature.local);
        }

        public Builder broker() {
            return this.features(Feature.broker);
        }

        public Builder shared() {
            return this.features(Feature.shared);
        }

        public Builder sharedOldest() {
            return this.features(Feature.shared, Feature.sharedOldest);
        }

        public Subscription build() {
            if (this.features.isEmpty()) {
                this.local();
            }
            Assert.notEmpty(this.topics, "topic cannot be empty");
            Assert.hasText(this.subscriber, "subscriber cannot be empty");
            return new Subscription(this.subscriber, this.topics.toArray(new String[0]), this.features.toArray(new Feature[0]), this.doOnSubscribe, this.priority);
        }
    }

    @Dict(value="subscription-feature")
    public static enum Feature implements EnumDict<String>
    {
        shared("shared"),
        local("\u8ba2\u9605\u672c\u5730\u6d88\u606f"),
        broker("\u8ba2\u9605\u4ee3\u7406\u6d88\u606f"),
        sharedOldest("\u76f8\u540c\u8ba2\u9605\u8005\u603b\u662f\u6700\u5148\u8ba2\u9605\u7684\u6536\u5230\u6570\u636e");

        private final String text;

        @Override
        public String getValue() {
            return this.name();
        }

        private Feature(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

