/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import reactor.function.Function3;

public class ErrorCodec
implements Codec<Throwable> {
    public static ErrorCodec RUNTIME;
    public static ErrorCodec DEFAULT;
    private final Function3<String, String, String, Throwable> mapping;

    public static ErrorCodec of(Function<String, Throwable> mapping) {
        return new ErrorCodec((type, msg, stack) -> (Throwable)mapping.apply((String)msg));
    }

    public static ErrorCodec of(Function3<String, String, String, Throwable> mapping) {
        return new ErrorCodec(mapping);
    }

    @Override
    public Class<Throwable> forType() {
        return Throwable.class;
    }

    @Override
    public Throwable decode(@Nonnull Payload payload) {
        String body2 = payload.bodyToString(false);
        if (body2.startsWith("{")) {
            JSONObject json = JSON.parseObject(body2);
            return this.mapping.apply(json.getString("t"), json.getString("m"), json.getString("s"));
        }
        return this.mapping.apply(null, body2, null);
    }

    @Override
    public Payload encode(Throwable body2) {
        JSONObject state = new JSONObject();
        state.put("m", (Object)body2.getMessage());
        state.put("t", (Object)body2.getClass().getName());
        state.put("s", (Object)StringUtils.throwable2String(body2));
        return Payload.of(state.toJSONString());
    }

    private ErrorCodec(Function3<String, String, String, Throwable> mapping) {
        this.mapping = mapping;
    }

    static {
        DEFAULT = RUNTIME = ErrorCodec.of((String type, String msg, String stack) -> stack == null ? new RuntimeException((String)msg) : new RuntimeException((String)stack));
    }
}

