/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.exception;

import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.hswebframework.web.i18n.LocaleUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class TraceSourceException
extends RuntimeException {
    private static final String deepTraceKey = TraceSourceException.class.getName() + "_deep";
    private static final Context deepTraceContext = Context.of(deepTraceKey, true);
    private String operation;
    private Object source;

    public TraceSourceException() {
    }

    public TraceSourceException(String message) {
        super(message);
    }

    public TraceSourceException(Throwable e) {
        super(e.getMessage(), e);
    }

    public TraceSourceException(String message, Throwable e) {
        super(message, e);
    }

    @Nullable
    public Object getSource() {
        return this.source;
    }

    @Nullable
    public String getOperation() {
        return this.operation;
    }

    public TraceSourceException withSource(Object source) {
        this.source = source;
        return this.self();
    }

    public TraceSourceException withSource(String operation, Object source) {
        this.operation = operation;
        this.source = source;
        return this.self();
    }

    protected TraceSourceException self() {
        return this;
    }

    public static Context deepTraceContext() {
        return deepTraceContext;
    }

    public static <T> Function<Throwable, Mono<T>> transfer(Object source) {
        return TraceSourceException.transfer(null, source);
    }

    public static <T> Function<Throwable, Mono<T>> transfer(String operation, Object source) {
        if (source == null && operation == null) {
            return Mono::error;
        }
        return err -> {
            if (err instanceof TraceSourceException) {
                return Mono.deferWithContext(ctx -> {
                    if (ctx.hasKey(deepTraceKey)) {
                        return Mono.error(new TraceSourceException((Throwable)err).withSource(operation, source));
                    }
                    return Mono.error(((TraceSourceException)err).withSource(operation, source));
                });
            }
            return Mono.error(new TraceSourceException((Throwable)err).withSource(operation, source));
        };
    }

    public static Object tryGetSource(Throwable err) {
        if (err instanceof TraceSourceException) {
            return ((TraceSourceException)err).getSource();
        }
        return null;
    }

    public static String tryGetOperation(Throwable err) {
        if (err instanceof TraceSourceException) {
            return ((TraceSourceException)err).getOperation();
        }
        return null;
    }

    public static String tryGetOperationLocalized(Throwable err, Locale locale) {
        String opt = TraceSourceException.tryGetOperation(err);
        return StringUtils.hasText(opt) ? LocaleUtils.resolveMessage(opt, locale, opt, new Object[0]) : opt;
    }

    public static Mono<String> tryGetOperationLocalizedReactive(Throwable err) {
        return LocaleUtils.currentReactive().handle((locale, sink) -> {
            String opt = TraceSourceException.tryGetOperationLocalized(err, locale);
            if (opt != null) {
                sink.next(opt);
            }
        });
    }
}

