/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;

@VertxGen
public interface HttpClientRequest
extends WriteStream<Buffer> {
    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> var1);

    public HttpClientRequest setWriteQueueMaxSize(int var1);

    public HttpClientRequest drainHandler(Handler<Void> var1);

    @Fluent
    public HttpClientRequest setHost(String var1);

    public String getHost();

    @Fluent
    public HttpClientRequest setPort(int var1);

    public int getPort();

    @Fluent
    public HttpClientRequest setFollowRedirects(boolean var1);

    @Fluent
    public HttpClientRequest setMaxRedirects(int var1);

    @Fluent
    public HttpClientRequest setChunked(boolean var1);

    public boolean isChunked();

    public HttpMethod getMethod();

    @Fluent
    public HttpClientRequest setMethod(HttpMethod var1);

    public String absoluteURI();

    public String getURI();

    @Fluent
    public HttpClientRequest setURI(String var1);

    public String path();

    public String query();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpClientRequest putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, Iterable<CharSequence> var2);

    public HttpVersion version();

    @Override
    public Future<Void> write(String var1);

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> write(String var1, String var2);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public HttpClientRequest continueHandler(@Nullable Handler<Void> var1);

    public Future<Void> sendHead();

    @Fluent
    public HttpClientRequest sendHead(Handler<AsyncResult<Void>> var1);

    public void connect(Handler<AsyncResult<HttpClientResponse>> var1);

    public Future<HttpClientResponse> connect();

    @Fluent
    public HttpClientRequest response(Handler<AsyncResult<HttpClientResponse>> var1);

    public Future<HttpClientResponse> response();

    default public void send(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end();
    }

    default public Future<HttpClientResponse> send() {
        this.end();
        return this.response();
    }

    default public void send(String body2, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end(body2);
    }

    default public Future<HttpClientResponse> send(String body2) {
        this.end(body2);
        return this.response();
    }

    default public void send(Buffer body2, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end(body2);
    }

    default public Future<HttpClientResponse> send(Buffer body2) {
        this.end(body2);
        return this.response();
    }

    default public void send(ReadStream<Buffer> body2, Handler<AsyncResult<HttpClientResponse>> handler) {
        MultiMap headers2 = this.headers();
        if (headers2 == null || !headers2.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        this.response(handler);
        body2.pipeTo(this);
    }

    default public Future<HttpClientResponse> send(ReadStream<Buffer> body2) {
        MultiMap headers2 = this.headers();
        if (headers2 == null || !headers2.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        body2.pipeTo(this);
        return this.response();
    }

    @Override
    public Future<Void> end(String var1);

    @Override
    public void end(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> end(String var1, String var2);

    public void end(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public void end(Buffer var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end();

    @Override
    public void end(Handler<AsyncResult<Void>> var1);

    @Fluent
    public HttpClientRequest setTimeout(long var1);

    @Fluent
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> var1);

    default public boolean reset() {
        return this.reset(0L);
    }

    public boolean reset(long var1);

    public boolean reset(long var1, Throwable var3);

    @CacheReturn
    public HttpConnection connection();

    @Fluent
    public HttpClientRequest writeCustomFrame(int var1, int var2, Buffer var3);

    default public int streamId() {
        return -1;
    }

    @Fluent
    default public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    public StreamPriority getStreamPriority();
}

