/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.ReplyHandler;
import java.util.List;
import java.util.Map;

public class MessageImpl<U, V>
implements Message<V> {
    protected MessageCodec<U, V> messageCodec;
    protected final EventBusImpl bus;
    protected String address;
    protected String replyAddress;
    protected MultiMap headers;
    protected U sentBody;
    protected V receivedBody;
    protected boolean send;
    protected Object trace;

    public MessageImpl(EventBusImpl bus) {
        this.bus = bus;
    }

    public MessageImpl(String address, MultiMap headers2, U sentBody, MessageCodec<U, V> messageCodec, boolean send, EventBusImpl bus) {
        this.messageCodec = messageCodec;
        this.address = address;
        this.headers = headers2;
        this.sentBody = sentBody;
        this.send = send;
        this.bus = bus;
    }

    protected MessageImpl(MessageImpl<U, V> other) {
        this.bus = other.bus;
        this.address = other.address;
        this.replyAddress = other.replyAddress;
        this.messageCodec = other.messageCodec;
        if (other.headers != null) {
            List<Map.Entry<String, String>> entries = other.headers.entries();
            this.headers = MultiMap.caseInsensitiveMultiMap();
            for (Map.Entry<String, String> entry : entries) {
                this.headers.add(entry.getKey(), entry.getValue());
            }
        }
        if (other.sentBody != null) {
            this.sentBody = other.sentBody;
            this.receivedBody = this.messageCodec.transform(other.sentBody);
        }
        this.send = other.send;
    }

    public MessageImpl<U, V> copyBeforeReceive() {
        return new MessageImpl<U, V>(this);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.headers;
    }

    @Override
    public V body() {
        if (this.receivedBody == null && this.sentBody != null) {
            this.receivedBody = this.messageCodec.transform(this.sentBody);
        }
        return this.receivedBody;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    @Override
    public void reply(Object message, DeliveryOptions options) {
        if (this.replyAddress != null) {
            MessageImpl reply = this.createReply(message, options);
            this.bus.sendReply(reply, options, null);
        }
    }

    @Override
    public <R> Future<Message<R>> replyAndRequest(Object message, DeliveryOptions options) {
        if (this.replyAddress != null) {
            MessageImpl reply = this.createReply(message, options);
            ReplyHandler handler = this.bus.createReplyHandler(reply, false, options);
            this.bus.sendReply(reply, options, handler);
            return handler.result();
        }
        throw new IllegalStateException();
    }

    protected MessageImpl createReply(Object message, DeliveryOptions options) {
        MessageImpl reply = this.bus.createMessage(true, this.replyAddress, options.getHeaders(), message, options.getCodecName());
        reply.trace = this.trace;
        return reply;
    }

    @Override
    public boolean isSend() {
        return this.send;
    }

    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    public MessageCodec<U, V> codec() {
        return this.messageCodec;
    }

    protected boolean isLocal() {
        return true;
    }
}

